/* Copyright (c) <2016> <MultiTech Systems>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "CmdTxDataRate.h"
#include "MTSText.h"
#include "MTSLog.h"

CmdTxDataRate::CmdTxDataRate(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Tx Data Rate", "AT+TXDR", "Set the Tx data rate for all channels"),
  _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "7-10|DR0-DR15, Depends on Channel Plan";
    _queryable = true;
}

uint32_t CmdTxDataRate::action(std::vector<std::string> args) {
    if (args.size() == 1)
        {
        _serial.writef("DR%d - %s\r\n", _dot->getTxDataRate(), _dot->getDateRateDetails(_dot->getTxDataRate()).c_str());
    } else if (args.size() == 2) {
        std::string dr = mts::Text::toUpper(args[1]);
        int32_t code;
        int datarate = -1;
        uint8_t i;

        int res = sscanf(dr.c_str(), "%d", &datarate);

        if (res == 0) {
            for (i = 0; i < 24; i++) {
                if (mDot::DataRateStr(i).find(dr) != std::string::npos) {
                    datarate = i;
                    break;
                }
            }
        }

        if ((code = _dot->setTxDataRate(datarate)) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());
            return 1;
        }
    }

    return 0;
}

bool CmdTxDataRate::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
        return true;

    setErrorMessage("Invalid arguments");
    return false;
}
