/** Dragonfly Serial Example Program
 *
 * This program demonstrates how to do handle a serial port
 * using the MultiTech Dragonfly and MultiTech UDK2 hardware.
 *
 * This program echos characters on the debug serial port.
 * The debug serial port is operated at the default baud, 9600.
 * Connect your terminal application to the appropriate COM/tty
 * port on your PC. See https://developer.mbed.org/handbook/SerialPC
 * for details.
 */
 
#include "mbed.h"

// This line controls the regulator's battery charger.
// BC_NCE = 0 enables the battery charger
// BC_NCE = 1 disables the battery charger
DigitalOut bc_nce(PB_2);
 
int main() {
    // Disable the battery charger unless a battery is attached.
    bc_nce = 1;
    
    Serial pc(USBTX, USBRX);
    
    while (true)
        if (pc.readable())
            pc.putc(pc.getc());
}