/** Dragonfly PwmOut Example Program
 *
 * This program demonstrates how to do pulse width modulation on
 * and output pin using the MultiTech Dragonfly and MultiTech UDK2
 * hardware. The only additional hardware required is a LED.
 *
 * This program PWMs the D12 pin. It should go from 0% to 100% duty
 * cycle in 5% increments and then from 100% to 0% in 5% increments.
 */
 
#include "mbed.h"

// This line controls the regulator's battery charger.
// BC_NCE = 0 enables the battery charger
// BC_NCE = 1 disables the battery charger
DigitalOut bc_nce(PB_2);
 
int main() {
    // Disable the battery charger unless a battery is attached.
    bc_nce = 1;
    
    PwmOut out(D12);
    
    while (true) {
        for (float f = 0.0f; f < 1.0f; f += 0.05f) {
            out = f;
            wait_ms(50);
        }
        for (float f = 1.0f; f > 0.0f; f -= 0.05f) {
            out = f;
            wait_ms(50);
        }
    }
}