/** Dragonfly InterruptIn Example Program
 *
 * This program demonstrates how to handle external interrupts using the
 * MultiTech Dragonfly and MultiTech UDK2 hardware. The only
 * additional hardware required is a jumper wire.
 *
 * Pins are active low, so 0V = 0 and 5V/3.3V = 1.
 *
 * This program configures interrupt handlers for rising and falling edges
 * on pin D9.
 */
 
#include "mbed.h"

// This line controls the regulator's battery charger.
// BC_NCE = 0 enables the battery charger
// BC_NCE = 1 disables the battery charger
DigitalOut bc_nce(PB_2);

bool rise_flag = false;
bool fall_flag = false;

void rise_handler(void) {
    rise_flag = true;
}

void fall_handler(void) {
    fall_flag = true;
}
 
int main() {
    // Disable the battery charger unless a battery is attached.
    bc_nce = 1;
    
    InterruptIn in(D9);
    in.rise(&rise_handler);
    in.fall(&fall_handler);
    
    while (true) {
        if (rise_flag) {
            printf("rising edge\r\n");
            rise_flag = false;
        }
        if (fall_flag) {
            printf("falling edge\r\n");
            fall_flag = false;
        }
        
        wait_ms(100);
    }
}