/** Dragonfly DigitalOut and BusOut Example Program
 *
 * This program demonstrates how to write digital outputs using the
 * MultiTech Dragonfly and MultiTech UDK2 hardware. The only
 * additional hardware required is LEDs. Connect the LEDs between the
 * bus pins and ground.
 *
 * Pins are active low, so 0V = 0 and 5V/3.3V = 1.
 *
 * This program blinks the D3 LED using a DigitalOut pin and writes
 * to pins D9, D10, and D12 as a 3 pin bus.
 */
 
#include "mbed.h"

// This line controls the regulator's battery charger.
// BC_NCE = 0 enables the battery charger
// BC_NCE = 1 disables the battery charger
DigitalOut bc_nce(PB_2);
 
int main() {
    // Disable the battery charger unless a battery is attached.
    bc_nce = 1;
    
    // write digital pins D9, D10, and D12 as a 3 pin bus
    // the first pin is the LSB of the bus, the last is the MSB
    BusOut bus(D9, D10, D12);
    // pin D3 is connected to the LED
    DigitalOut led(D3);
    
    int count = 0;
    
    while (true) {
        printf("writing %d to bus\r\n", count);
        bus = count++;
        count %= 8;
        
        led = !led;
        
        wait_ms(500);
    }
}