/** Dragonfly DigitalIn and BusIn Example Program
 *
 * This program demonstrates how to read digital inputs using the
 * MultiTech Dragonfly and MultiTech UDK2 hardware. The only
 * additional hardware required is jumper wires.
 *
 * Pins are active low, so 0V = 0 and 5V/3.3V = 1.
 *
 * This program prints the new value of the BusIn each time it changes
 * and the new value of the DigitalIn each time it changes.
 */
 
#include "mbed.h"

// This line controls the regulator's battery charger.
// BC_NCE = 0 enables the battery charger
// BC_NCE = 1 disables the battery charger
DigitalOut bc_nce(PB_2);
 
int main() {
    // Disable the battery charger unless a battery is attached.
    bc_nce = 1;
    
    // read digital pins D9 and D10 as a 2 pin bus
    // the first pin is the LSB of the bus, the last is the MSB
    BusIn bus(D9, D10);
    // read digital pin D12
    DigitalIn din(D12);
    
    int old_bus = -1;
    int old_din = -1;
    
    while (true) {
        if (bus != old_bus) {
            old_bus = bus;
            printf("bus = %d\r\n", old_bus);
        }
        if (din != old_din) {
            old_din = din;
            printf("din = %d\r\n", old_din);
        }
        
        wait_ms(100);
    }
}