/** Dragonfly AnalogIn Example Program
 *
 * This program demonstrates how to read an anglog pin using the
 * MultiTech Dragonfly and MultiTech UDK2 hardware. The only
 * additional hardware required is an analog voltage source like
 * a potentiometer.
 *
 *
 * This program reads the analog input connected to pin A0 and
 * prints the result.
 */
 
#include "mbed.h"

// This line controls the regulator's battery charger.
// BC_NCE = 0 enables the battery charger
// BC_NCE = 1 disables the battery charger
DigitalOut bc_nce(PB_2);
 
int main() {
    // Disable the battery charger unless a battery is attached.
    bc_nce = 1;
    
    AnalogIn in(A0);
    
    while (true) {
        printf("analog value: 0x%04X\r\n", in.read_u16());
        wait_ms(500);
    }
}