// This example program will first delete any stored messages held in the radio.
// Then it will send an SMS message before looping while reading received SMS
// message. 
//
// ** Configure the apn[] value below for MTQ-H5 or MTQ-LAT3 radios.
// ** Configure txtmsg.phone_number below for SMS destination.

#include "mbed.h"
#include "MTSCellularInterface.h"
#include "MTSLog.h"
#include "example_config.h"

#if ACTIVE_EXAMPLE == SMS_EXAMPLE

// Dragonfly debug port. 
Serial debug_port(USBTX, USBRX);

int main(){
    //Sets the log level to INFO, higher log levels produce more log output.
    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG and TRACE.
    //For the Dragonfly, installed on the UDK 2.0 board, messages are output on the
    // UDK 2.0 USB port “COMxx: STMicroelectronics STLink Virtual COM port (xx)”
    // at 9600bps.    
    mts::MTSLog::setLogLevel(mts::MTSLog::INFO_LEVEL);
    //Sets the debug port to 115200bps.
    debug_port.baud(115200);

    // Create an MTSCellularInterface object. Serial pins for the Dragonfly board that connect
    // to the on board cellular radio:
    // RADIO_TX = pin PC_7, RADIO_RX = pin PC_6
    MTSCellularInterface *radio = new MTSCellularInterface(RADIO_TX, RADIO_RX);
    
    // Print the MTSCellularInterface version
    logInfo("MTSCellularInterface Version %s", radio->get_library_version().c_str());

    //Modify to match your apn if you are using an HSPA radio with a SIM card.
    const char apn[] = "";
    
    //Phone number to send to and receive from. Must be in the form "1xxxxxxxxxx"
    MTSCellularRadio::Sms txtmsg;
    txtmsg.phone_number = "";
    txtmsg.message = "Hello World! MTSCellularInterface is up and running!";

    //Set radio apn
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to set apn\n");
        }
        else if (radio->set_credentials(apn) == NSAPI_ERROR_OK) {
            logInfo("Successfully set apn\n");
            break;
        } else {
            wait(1);
        }
    }
    
    //Delete any previously received SMS messages
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to delete SMS messages\n");
        }
        else if (radio->delete_all_received_sms() == NSAPI_ERROR_OK) {
            logInfo("Deleted all SMS messages\n");
            break;
        } else {
            wait(1);
        }
    }

    // Send SMS message to phone
    for (int i = 1; i < 10; i++) {
        if(radio->send_sms(txtmsg) == NSAPI_ERROR_OK) {
            logInfo("Sent SMS successfully:<%s>\n", txtmsg.message.c_str());
            break;
        } else {
            logError("Failed to send SMS<%s>\n", txtmsg.message.c_str());
        }
    }
    
    //Checking for received SMS messages
    while (true) {
        logInfo("Checking for received messages");
        vector<MTSCellularRadio::Sms> recv = radio->get_received_sms();
        if(recv.size() > 0) {
            int size = recv.size();
            for (int i = 0; i < size; i++) {
                logInfo("Message %d: [%s] [%s] [%s]", i, recv[i].phone_number.c_str(), recv[i].timestamp.c_str(), recv[i].message.c_str());
            }
        }
        
        if(radio->delete_only_read_sms() != NSAPI_ERROR_OK) {
            logError("Failed to delete received and read SMS messages");
        }
        wait(10);
    }
    
    return 0;
}

#endif
