#include "CmdAdaptiveDataRate.h"


CmdAdaptiveDataRate::CmdAdaptiveDataRate() :
#if MTS_CMD_TERM_VERBOSE
    Command("Adaptive Data Rate", "AT+ADR", "Enable/disable ADR(0:off,1: on),[ADR_ACK_LIMIT(1-127)],[ADR_ACK_DELAY(1-127)],Auto Inc DR(0:off,1:on)", "(0,1),(1,127),(1,127),(0,1)")
#else
    Command("AT+ADR")
#endif
{
    _queryable = true;
}

uint32_t CmdAdaptiveDataRate::action(const std::vector<std::string>& args)
{
    if (args.size() == 1)
    {
        CommandTerminal::Serial()->writef("%d, %d, %d, %d\r\n",
                                          CommandTerminal::Dot()->getAdr(),
                                          CommandTerminal::Dot()->getAdrAckLimit(),
                                          CommandTerminal::Dot()->getAdrAckDelay(),
                                          !CommandTerminal::Dot()->getDisableIncrementDR());
    }
    else if (args.size() > 1)
    {
        bool enable = (args[1] == "1");
        if (CommandTerminal::Dot()->setAdr(enable) != mDot::MDOT_OK)
        {
            return 1;
        }

        if (args.size() > 2)
        {
            int input;
            sscanf(args[2].c_str(), "%d", &input);
            CommandTerminal::Dot()->setAdrAckLimit(input);

            if (args.size() > 3)
            {
                sscanf(args[3].c_str(), "%d", &input);
                CommandTerminal::Dot()->setAdrAckDelay(input);
            }

            if ((args.size() > 4) && (args[4] == "0" || args[4] == "1")) {
                // input 1:on = false because setting true disables
                CommandTerminal::Dot()->setDisableIncrementDR(args[4] == "0");
            }
        }
    }

    return 0;
}

bool CmdAdaptiveDataRate::verify(const std::vector<std::string>& args)
{
    if (args.size() == 1)
        return true;

    if (args[1] != "1" && args[1] != "0") {
#if MTS_CMD_TERM_VERBOSE
        CommandTerminal::setErrorMessage("Invalid parameter1, expects (0: off, 1: on)");
#endif
        return false;
    }

    int input;

    if (args.size() == 2) {
        return true;
    } else {
        sscanf(args[2].c_str(), "%d", &input);

        if (input < 1 || input > 127) {
    #if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid parameter2, expects ADR_ACK_LIMIT (1-127)");
    #endif
            return false;
        }
    }

    if (args.size() == 3)
    {
        return true;
    } else {
        sscanf(args[3].c_str(), "%d", &input);
        if (input < 1 || input > 127) {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid parameter3, expects ADR_ACK_DELAY (1-127)");
#endif
            return false;
        }
    }

    if (args.size() == 4) {
        return true;
    }

    if (args[4] != "0" && args[4] != "1") {
#if MTS_CMD_TERM_VERBOSE
        CommandTerminal::setErrorMessage("Invalid parameter4, expects (0: off, 1: on)");
#endif
        return false;
    }

    if (args.size() == 5) {
        return true;
    }

#if MTS_CMD_TERM_VERBOSE
    CommandTerminal::setErrorMessage("Invalid arguments");
#endif
    return false;
}
