#ifndef __COMMANDS_H__
#define __COMMANDS_H__

#include "Command.h"
#include "CmdDummy.h"

#include "CmdIdentification.h"
#include "CmdResetCpu.h"
// Echo built into command terminal
// Verbose built into command terminal
//
#include "CmdFactoryDefault.h"
#if MTS_CMD_TERM_VERBOSE
#include "CmdDisplayConfig.h"
#include "CmdDisplayStats.h"
#endif
#include "CmdResetStats.h"

#include "CmdSerialBaudRate.h"
#include "CmdSerialClearOnError.h"
#include "CmdDebugBaudRate.h"
#include "CmdStartUpMode.h"

#include "CmdDefaultFrequencyBand.h"
#include "CmdFrequencyBand.h"
#include "CmdDeviceId.h"
#include "CmdDeviceClass.h"
#include "CmdPublicNetwork.h"
#include "CmdNetworkAddress.h"
#include "CmdNetworkSessionKey.h"
#include "CmdDataSessionKey.h"
#include "CmdUplinkCounter.h"
#include "CmdDownlinkCounter.h"
#include "CmdRestoreSession.h"
#include "CmdCustomDeviceID.h"
#include "CmdCustomSerialNumber.h"
#include "CmdNetworkKey.h"
#include "CmdGenAppKey.h"
#include "CmdNetworkId.h"
#include "CmdAppPort.h"
#include "CmdJoinRequest.h"
#include "CmdJoinRetries.h"
#include "CmdJoinNonce.h"
#include "CmdJoinNonceValidation.h"
#include "CmdJoinDelay.h"
// Remove join settings commands until valid case for changing default settings
//#include "CmdJoinRx1Offset.h"
//#include "CmdJoinRx2Datarate.h"
//#include "CmdJoinRx2Frequency.h"
#include "CmdNetworkJoinMode.h"
#include "CmdPreserveSession.h"
#include "CmdNetworkJoinStatus.h"
#include "CmdNetworkLinkCheck.h"
#include "CmdLinkCheckCount.h"
#include "CmdLinkCheckThreshold.h"
#include "CmdRssi.h"
#include "CmdSnr.h"

#include "CmdSessionDataRate.h"
#include "CmdChannelMask.h"

#include "CmdTxDataRate.h"
#include "CmdAntennaGain.h"
#include "CmdTxPower.h"
#include "CmdTxWait.h"
#include "CmdTxFrequencyOffset.h"
#include "CmdTxChannel.h"
#include "CmdTxNextMs.h"
#include "CmdTxNextSize.h"
#include "CmdTimeOnAir.h"
#include "CmdFrequencySubBand.h"
#include "CmdLbt.h"

#include "CmdRxDelay.h"
#include "CmdRxOutput.h"
#include "CmdMulticastRx.h"

#include "CmdAdaptiveDataRate.h"

#include "CmdACKAttempts.h"
#include "CmdRepeat.h"
#include "CmdPingPeriod.h"
#include "CmdMacCmd.h"
#include "CmdSendString.h"
#include "CmdSendBinary.h"
#include "CmdReceiveOnce.h"
#include "CmdPing.h"
#include "CmdClassBTimeout.h"
#include "CmdClassCTimeout.h"

// Serial Data Mode built into command terminal
// Sleep built into command terminal
#include "CmdWakeInterval.h"
#include "CmdWakePin.h"
#include "CmdWakeMode.h"
#include "CmdWakeDelay.h"
#include "CmdWakeTimeout.h"

#include "CmdLogLevel.h"

#include "CmdRtc.h"
#include "CmdFota.h"
#include "CmdGpsTime.h"
#include "CmdBeaconLockStatus.h"
#include "CmdLBTRSSI.h"
#include "CmdBatteryLevel.h"
#include "CmdTxFrequency.h"
#include "CmdDutyCycle.h"
#include "CmdDisableDutyCycle.h"

#if MTS_CMD_TERM_TEST_COMMANDS
#include "CmdRxDataRate.h"
#include "CmdSendStringOnInterval.h"
#include "CmdSendContinuous.h"
#include "CmdSweep.h"
#endif

#if defined(TARGET_MTS_MDOT_F411RE)
#include "CmdRepairFlash.h"
#include "CmdWriteOtp.h"
#endif

#ifdef MTS_RADIO_DEBUG_COMMANDS
// Radio debug commands
#include "CmdDumpRegisters.h"
#include "CmdEraseFlash.h"
#include "CmdReceiveContinuous.h"
#endif

#if defined(TARGET_XDOT_MAX32670)

#ifdef MTS_RADIO_CTRL_COMMANDS
#include "CmdTXPwrMode.h"
#include "CmdPaDutyConf.h"
#include "CmdHpMaxConf.h"
#include "CmdLnaConf.h"
#include "CmdXTATrim.h"
#include "CmdXTBTrim.h"
#include "CmdSetSW.h"
#include "CmdRamp.h"
#include "CmdInfPreamble.h"
#include "CmdRadioSleep.h"
#include "CmdSendDI.h"
#include "CmdRxFrequency.h"

#endif // MTS_RADOI_CTRL_COMMANDS
#endif // TARGET_XDOT_MAX32670

#endif // __COMMANDS_H__
