#include "CmdSweep.h"
#include "CommandTerminal.h"

CmdSweep::CmdSweep() :
#if MTS_CMD_TERM_VERBOSE
    Command("Sweep", "AT+SW", "Send un-modulated data continuously over range", "[START],[STOP],[STEP],[DURATION],[POWER]")
#else
    Command("AT+SW")
#endif
{
}

uint32_t CmdSweep::action(const std::vector<std::string>& args) {

    int timeout = 0;
    int fstart = 0;
    int fstop = 0;
    int fstep = 0;
    int power = 20;
    int loops = 1;

    if (args.size() > 1) {
        sscanf(args[1].c_str(), "%d", &fstart);
    }
    if (args.size() > 2) {
        sscanf(args[2].c_str(), "%d", &fstop);
    }
    if (args.size() > 3) {
        sscanf(args[3].c_str(), "%d", &fstep);
    }
    if (args.size() > 4) {
        sscanf(args[4].c_str(), "%d", &timeout);
    }
    if (args.size() > 5) {
        sscanf(args[5].c_str(), "%d", &power);
    }
    if (args.size() > 6) {
        sscanf(args[6].c_str(), "%d", &loops);
    }

    int frequency = fstart;


    while (loops > 0) {
        while (frequency < fstop) {
            CommandTerminal::Serial()->writef("CW on %lu at %d dBm\r\n", frequency, power);
            CommandTerminal::Dot()->sendContinuous(true, timeout, frequency, power);
            frequency += fstep;
            if (CommandTerminal::Serial()->escaped()) {
                loops = 0;
                break;
            }
        }
        frequency = fstart;
        loops--;
    }

    CommandTerminal::Serial()->clearEscaped();

    return 0;
}

bool CmdSweep::verify(const std::vector<std::string>& args)
{
    int arg;

    if (args.size() == 1)
        return true;

    // Verify all optional arguments are valid numbers
    // No range checking because this command is for test use
    for (size_t i = 1; i < args.size(); ++i) {
        if (sscanf(args[i].c_str(), "%d", &arg) != 1) {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument");
#endif
            return false;
        }
    }

    return true;
}