#include "CmdJoinRequest.h"
#include "CommandTerminal.h"

CmdJoinRequest::CmdJoinRequest() :
#if MTS_CMD_TERM_VERBOSE
    Command("Join Network", "AT+JOIN", "Join network, provide argument of '1' to force join (acquire network address and session keys)", "(force:1,usetxdr:2)")
#else
    Command("AT+JOIN")
#endif
{

}

uint32_t CmdJoinRequest::action(const std::vector<std::string>& args) {
    // Detach the serial rx irq handler temporarily here to allow for deep sleep
    //CommandTerminal::Serial()->detach();

    std::string buf;
    uint32_t ret = 0;

    if (args.size() > 1 && args[1] == "1")
        CommandTerminal::Dot()->resetNetworkSession();

    if (CommandTerminal::Dot()->getJoinMode() == 0) {
        CommandTerminal::Serial()->writef("Join not necessary for Manual Join Mode\r\n");
        //CommandTerminal::Serial()->attach();
        return 0;
    } else if (CommandTerminal::Dot()->getJoinMode() == 3) {
        CommandTerminal::Serial()->writef("Join not necessary for Peer-to-Peer\r\n");
        //CommandTerminal::Serial()->attach();
        return 0;
    } else {

        if (args.size() > 1 && args[1] == "2")
            CommandTerminal::Dot()->setDisableAutoJoinDatarate(true);

        int32_t code = CommandTerminal::Dot()->joinNetworkOnce();

        if (code == mDot::MDOT_OK) {
            CommandTerminal::Serial()->writef("Successfully joined network\r\n");
            //CommandTerminal::Serial()->attach();

        } else {
            ret = 1;
            // std::string error = mDot::getReturnCodeString(code)  + " - " + CommandTerminal::Dot()->getLastError();
            // CommandTerminal::setErrorMessage(CommandTerminal::Dot()->getLastError());
        }

        if (args.size() > 1 && args[1] == "2")
            CommandTerminal::Dot()->setDisableAutoJoinDatarate(false);

    }

    //CommandTerminal::Serial()->attach();
    return ret;
}

bool CmdJoinRequest::verify(const std::vector<std::string>& args) {
    if (args.size() == 1 || (args.size() == 2 && (args[1] == "1" || args[1] == "2")))
        return true;

#if MTS_CMD_TERM_VERBOSE
    CommandTerminal::setErrorMessage("Invalid arguments");
#endif
    return false;
}
