#include "CmdJoinNonce.h"

CmdJoinNonce::CmdJoinNonce() :
#if MTS_CMD_TERM_VERBOSE
    Command("Join Nonces", "AT+JN", "Set OTA Join Nonce", "(0-65535),(0-16777215)")
#else
    Command("AT+JN")
#endif
{
    _queryable = true;
}

uint32_t CmdJoinNonce::action(const std::vector<std::string>& args) {
    if (args.size() == 1) {
        CommandTerminal::Serial()->writef("%u,%u\r\n", CommandTerminal::Dot()->getDevNonce(), CommandTerminal::Dot()->getAppNonce());
    } else if (args.size() == 3) {

        int nonce;
        int parsed = sscanf(args[1].c_str(), "%d", &nonce);

        if (parsed == 0 || CommandTerminal::Dot()->setDevNonce(nonce) != mDot::MDOT_OK) {
            return 1;
        }

        parsed = sscanf(args[2].c_str(), "%d", &nonce);

        if (parsed == 0 || CommandTerminal::Dot()->setAppNonce(nonce) != mDot::MDOT_OK) {
            return 1;
        }
    }

    return 0;
}

bool CmdJoinNonce::verify(const std::vector<std::string>& args) {
    bool ret = false;

    if (args.size() == 1)
        ret = true;

    if (args.size() == 3) {
        ret = true;

        int nonce;
        if (sscanf(args[1].c_str(), "%d", &nonce) == 1) {
            if (nonce < 0 || nonce > 65535) {
#if MTS_CMD_TERM_VERBOSE
                CommandTerminal::setErrorMessage("Invalid dev nonce, expects (0-65535)");
#endif
                ret = false;
            }
        } else {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid arguments");
#endif
            ret = false;
        }

        if (sscanf(args[2].c_str(), "%d", &nonce) == 1) {
            if (nonce < 0 || nonce > 16777215) {
#if MTS_CMD_TERM_VERBOSE
                CommandTerminal::setErrorMessage("Invalid app nonce, expects (0-16777215)");
#endif
                ret = false;
            }
        } else {
#if MTS_CMD_TERM_VERBOSE
                CommandTerminal::setErrorMessage("Invalid arguments");
#endif
            ret = false;
        }
    }

    return ret;
}

