#include "CmdIdentification.h"
#include "mts_at_version.h"

CmdIdentification::CmdIdentification() :
#if MTS_CMD_TERM_VERBOSE
    Command("Request Id", "ATI", "Request Identification", "NONE")
#else
    Command("ATI")
#endif
{
}

uint32_t CmdIdentification::action(const std::vector<std::string>& args)
{
    std::string version = AT_APPLICATION_VERSION;
#ifdef DEBUG_MAC
    version += "-debug";
#endif

    char buf[16];
    size_t size = snprintf(buf, sizeof(buf), "-mbed%d", MBED_VERSION);
    if (size > 0) {
        version.append(buf, size);
    }

#if defined(TARGET_MTS_MDOT_F411RE)
    CommandTerminal::Serial()->writef("MultiTech mDot\r\n");
#elif defined(TARGET_XDOT_L151CC)
    CommandTerminal::Serial()->writef("MultiTech xDot\r\n");
#elif defined(TARGET_MAX32660EVSYS)
   CommandTerminal::Serial()->writef("%s\r\n", version.c_str());
   return 0;
#elif defined(TARGET_XDOTES_MAX32670)
    CommandTerminal::Serial()->writef("MultiTech xDot-ES\r\n");
#elif defined(TARGET_XDOT_MAX32670)
    CommandTerminal::Serial()->writef("MultiTech xDot-1.5\r\n");
#else
    CommandTerminal::Serial()->writef("MultiTech LoRaWAN Radio\r\n");
#endif /* TARGET_MTS_MDOT_F411RE */
    CommandTerminal::Serial()->writef("Firmware : %s\r\n", version.c_str());
    CommandTerminal::Serial()->writef("Library  : %s\r\n", CommandTerminal::Dot()->getId().c_str());
    CommandTerminal::Serial()->writef("MTS-Lora : %s\r\n", CommandTerminal::Dot()->getMtsLoraId().c_str());

    return 0;
}
