#include "CmdCustomSerialNumber.h"

CmdCustomSerialNumber::CmdCustomSerialNumber() :
#if MTS_CMD_TERM_VERBOSE
    Command("Custom Serial Number", "AT+CSN", "Configure custom serial number", "(string:16)")
#else
    Command("AT+CSN")
#endif
{
    _queryable = true;
}

uint32_t CmdCustomSerialNumber::action(const std::vector<std::string>& args)
{
    if (args.size() == 1)
    {
        CommandTerminal::Serial()->writef("%s\r\n", CommandTerminal::Dot()->getCustomSerialNumber().c_str());
    }
    else if (args.size() == 2)
    {
        if (CommandTerminal::Dot()->setCustomSerialNumber(args[1]) == mDot::MDOT_OK)
        {
            CommandTerminal::Serial()->writef("Set ID: %s\r\n", args[1].c_str());
        }
        else
        {
            return 1;
        }
    }

    return 0;
}

bool CmdCustomSerialNumber::verify(const std::vector<std::string>& args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        if (args[1].size() > CUSTOM_FIELD_LENGTH) {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid length, expects (string:16)");
#endif
            return false;
        }

        return true;
    }

#if MTS_CMD_TERM_VERBOSE
    CommandTerminal::setErrorMessage("Invalid arguments");
#endif
    return false;
}
