#include "mbed.h"
#include "mDot.h"
#include "CommandTerminal.h"
#include "ChannelPlans.h"

#if defined(TARGET_XDOT_L151CC) && defined(FOTA)
#include "SPIFBlockDevice.h"
#include "DataFlashBlockDevice.h"
#endif

#if defined(TARGET_XDOT_L151CC) && defined(FOTA)

mbed::BlockDevice* ext_bd = NULL;

mbed::BlockDevice * mdot_override_external_block_device()
{
    if (ext_bd == NULL) {
        ext_bd = new SPIFBlockDevice();
        int ret = ext_bd->init();
        if (ext_bd->init() < 0) {
            delete ext_bd;
            ext_bd = new DataFlashBlockDevice();
            ret = ext_bd->init();
            // Check for zero size because DataFlashBlockDevice doesn't
            // return an error if the chip is not present
            if ((ret < 0) || (ext_bd->size() == 0)) {
                delete ext_bd;
                ext_bd = NULL;
            }
        }

        if (ext_bd != NULL) {
            logInfo("External flash device detected, type: %s, size: 0x%08x",
                ext_bd->get_type(), (uint32_t)ext_bd->size());
        }
    }

    return ext_bd;
}
#endif

#if defined(TARGET_MTS_MDOT_F411RE) // -----------------------------------------------------------

#define AT_TX_PIN   XBEE_DOUT
#define AT_RX_PIN   XBEE_DIN
#define AT_RTS_PIN  XBEE_RTS
#define AT_CTS_PIN  XBEE_CTS

#define DEBUG_TX    USBTX
#define DEBUG_RX    USBRX

#elif defined(TARGET_XDOT_L151CC) // -----------------------------------------------------------

#define AT_TX_PIN   UART1_TX
#define AT_RX_PIN   UART1_RX
#define AT_RTS_PIN  UART1_RTS
#define AT_CTS_PIN  UART1_CTS

#define DEBUG_TX    USBTX
#define DEBUG_RX    USBRX

#elif defined(TARGET_NUCLEO_L476RG) // -----------------------------------------------------------

#define AT_TX_PIN   D0
#define AT_RX_PIN   D1
#define AT_RTS_PIN  D7
#define AT_CTS_PIN  D8

#define DEBUG_TX    USBTX
#define DEBUG_RX    USBRX

#elif defined(TARGET_MAX32630FTHR) // -----------------------------------------------------------
#define AT_TX_PIN   UART2_TX
#define AT_RX_PIN   UART2_RX
#define AT_RTS_PIN  UART2_RTS
#define AT_CTS_PIN  UART2_CTS

#define DEBUG_TX    USBTX
#define DEBUG_RX    USBRX

#include "MAX14690.h"

I2C i2cBus(I2C2_SDA, I2C2_SCL);  // P5_7, P6_0

MAX14690 max14690(&i2cBus);

#elif defined(TARGET_MAX32660EVSYS) // -----------------------------------------------------------

#if defined(SWAP_UARTS)
#define AT_TX_PIN   UART0_TX
#define AT_RX_PIN   UART0_RX
#define AT_RTS_PIN  NC
#define AT_CTS_PIN  NC

#define DEBUG_TX    UART1C_TX
#define DEBUG_RX    UART1C_RX

#else
#define AT_TX_PIN   UART1C_TX
#define AT_RX_PIN   UART1C_RX
#define AT_RTS_PIN  NC
#define AT_CTS_PIN  NC

#define DEBUG_TX    UART0_TX
#define DEBUG_RX    UART0_RX
#endif

#include "flc.h"

#elif defined(TARGET_MAX32670EVKIT) || defined(TARGET_XDOT_MAX32670) // -----------------------------------------------------------

#define AT_TX_PIN   UART0_TX // UART0A_TX - P0_9
#define AT_RX_PIN   UART0_RX // UART0A_RX - P0_8
#define AT_RTS_PIN  UART0_RTS
#define AT_CTS_PIN  UART0_CTS

#define DEBUG_TX    UART1_TX // UART1A_TX - P0_29
#define DEBUG_RX    UART1_RX // UART1A_RX - P0_28

#include "pwrseq_regs.h"
#include "lp.h"

#else // -----------------------------------------------------------------------------------------
#error Unsupported target
#endif

#ifndef CHANNEL_PLAN
#define CHANNEL_PLAN CP_US915
#endif

#ifndef UNIT_TEST
#ifndef UNIT_TEST_MDOT_LIB


mbed::UnbufferedSerial debug_port(DEBUG_TX, DEBUG_RX, LOG_DEFAULT_BAUD_RATE);

FileHandle *mbed::mbed_override_console(int fd)
{
    return &debug_port;
}


int main()
{
#if defined(TARGET_XDOT_MAX32670) || defined(TARGET_XDOTES_MAX32670)

    // Port 1 has no pins exposed but must be configured for "low power".
    MXC_GPIO1->en0      =  0xFFFFFFFFUL;
    MXC_GPIO1->outen    =  0xFFFFFFFFUL;
    MXC_GPIO1->padctrl0 =  0xFFFFFFFFUL;
    MXC_GPIO1->ps       = 0x00000000UL;

#if defined(TARGET_XDOTES_MAX32670)
    printf("\r\nXDOTES\r\n");
#elif defined(TARGET_XDOT_MAX32670)
    printf("\r\nXDOT15\r\n");
#endif

    // Work around to be moved to SystemInit.c
    // MXC_PWRSEQ->lpcn &= ~(1 << 31); // Ensure ERTCO is on

#endif
#if defined(TARGET_MAX32630FTHR)
    i2cBus.frequency(400000);

    max14690.ldo2Millivolts = 3300;
    max14690.ldo3Millivolts = 3300;
    max14690.ldo2Mode = MAX14690::LDO_ENABLED;
    max14690.ldo3Mode = MAX14690::LDO_ENABLED;
    max14690.monCfg = MAX14690::MON_HI_Z;
    if (max14690.init() == MAX14690_ERROR) {
        printf("Error initializing MAX14690.\r\n");
    } else {
        printf("MAX14690 PMIC initialization is successful.\r\n");
    }
#endif
#if defined(DEBUG_MAC) && defined(TARGET_MTS_MDOT_F411RE) && CHANNEL_PLAN != CP_GLOBAL
    lora::ChannelPlan* plan = new lora::ChannelPlan_US915();
    mDot* dot = mDot::getInstance(plan);
#else
    lora::ChannelPlan* plan;
#if CHANNEL_PLAN == CP_AS923
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_AS923_2
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_AS923_3
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_AS923_4
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_US915
    plan = new lora::ChannelPlan_US915();
#elif CHANNEL_PLAN == CP_AU915
    plan = new lora::ChannelPlan_AU915();
#elif CHANNEL_PLAN == CP_EU868
    plan = new lora::ChannelPlan_EU868();
#elif CHANNEL_PLAN == CP_KR920
    plan = new lora::ChannelPlan_KR920();
#elif CHANNEL_PLAN == CP_IN865
    plan = new lora::ChannelPlan_IN865();
#elif CHANNEL_PLAN == CP_AS923_JAPAN
    plan = new lora::ChannelPlan_AS923_Japan();
#elif CHANNEL_PLAN == CP_AS923_JAPAN1
    plan = new lora::ChannelPlan_AS923_Japan1();
#elif CHANNEL_PLAN == CP_AS923_JAPAN2
    plan = new lora::ChannelPlan_AS923_Japan2();
#elif CHANNEL_PLAN == CP_RU864
    plan = new lora::ChannelPlan_RU864();
#elif CHANNEL_PLAN == CP_CN470
    plan = new lora::ChannelPlan_CN470();
#elif CHANNEL_PLAN == CP_GLOBAL
    plan = new lora::ChannelPlan_GLOBAL(CHANNEL_PLAN);
#endif
    mDot* dot = mDot::getInstance(plan);
#endif //MTS_MDOT_F411RE
    assert(dot);
#if CHANNEL_PLAN == CP_GLOBAL

    delete plan;
    plan = new lora::ChannelPlan_GLOBAL(dot->getDefaultFrequencyBand());
    dot->setChannelPlan(plan);

#elif defined(TARGET_MAX32660EVSYS) || defined(TARGET_MAX32630FTHR)
    logDebug("Loading default channel plan %02x", dot->getDefaultFrequencyBand());
    switch (dot->getDefaultFrequencyBand()) {
        case lora::ChannelPlan::US915:
        case lora::ChannelPlan::US915_OLD:
            delete plan;
            plan = new lora::ChannelPlan_US915();
            break;

        case lora::ChannelPlan::AU915:
        case lora::ChannelPlan::AU915_OLD:
            delete plan;
            plan = new lora::ChannelPlan_AU915();
            break;

        case lora::ChannelPlan::EU868:
        case lora::ChannelPlan::EU868_OLD:
            delete plan;
            plan = new lora::ChannelPlan_EU868();
            break;
        default:
            logInfo("Default channel plan not valid Defaulting US915");
            delete plan;
            plan = new lora::ChannelPlan_US915();
            break;
    }
    dot->setChannelPlan(plan);
#elif defined(DEBUG_MAC) && defined(TARGET_MTS_MDOT_F411RE)
    logDebug("Loading default channel plan %02x", dot->getDefaultFrequencyBand());
    switch (dot->getDefaultFrequencyBand()) {
        case lora::ChannelPlan::AS923:
        case lora::ChannelPlan::AS923_2:
        case lora::ChannelPlan::AS923_3:
            delete plan;
            plan = new lora::ChannelPlan_AS923();
            break;

        case lora::ChannelPlan::US915:
        case lora::ChannelPlan::US915_OLD:
            delete plan;
            plan = new lora::ChannelPlan_US915();
            break;

        case lora::ChannelPlan::AU915:
        case lora::ChannelPlan::AU915_OLD:
            delete plan;
            plan = new lora::ChannelPlan_AU915();
            break;

        case lora::ChannelPlan::EU868:
        case lora::ChannelPlan::EU868_OLD:
            delete plan;
            plan = new lora::ChannelPlan_EU868();
            break;

        case lora::ChannelPlan::KR920:
            delete plan;
            plan = new lora::ChannelPlan_KR920();
            break;

        case lora::ChannelPlan::AS923_JAPAN:
            delete plan;
            plan = new lora::ChannelPlan_AS923_Japan();
            break;

        case lora::ChannelPlan::AS923_JAPAN1:
            delete plan;
            plan = new lora::ChannelPlan_AS923_Japan1();
            break;

        case lora::ChannelPlan::AS923_JAPAN2:
            delete plan;
            plan = new lora::ChannelPlan_AS923_Japan2();
            break;

        case lora::ChannelPlan::IN865:
            delete plan;
            plan = new lora::ChannelPlan_IN865();
            break;

        case lora::ChannelPlan::RU864:
            delete plan;
            plan = new lora::ChannelPlan_RU864();
            break;

        default:
            logInfo("Default channel plan not valid Defaulting US915");
            delete plan;
            plan = new lora::ChannelPlan_US915();
            break;
    }
    dot->setChannelPlan(plan);
#endif
    // Seed the RNG
    srand(dot->getRadioRandom());

    mts::ATSerial serial(AT_TX_PIN, AT_RX_PIN, AT_RTS_PIN, AT_CTS_PIN, dot->getBaud());
    serial.flowControl(dot->getFlowControl());

    debug_port.baud(dot->getDebugBaud());

    CommandTerminal term(serial);
    CommandTerminal::_dot = dot;

    term.init();
    term.start();
}

#endif // UNIT_TEST
#endif
