The AT Firmware provides an AT interface to the Multitech LoRaWAN stack

Build Commands
------------------

$ mbed compile -m XDOT_L151CC -t ARMC6 --source . -DCHANNEL_PLAN=CP_EU868 --profile=release
$ mbed compile -m XDOT_L151CC -t ARMC6 --source . -DCHANNEL_PLAN=CP_GLOBAL --profile=release
$ mbed compile -m XDOT_L151CC -t ARMC6 --source . -DCHANNEL_PLAN=CP_AS923 --profile=release
$ mbed compile -m XDOT_L151CC -t ARMC6 --source . -DCHANNEL_PLAN=CP_AS923_2 --profile=release

$ mbed compile -m MTS_MDOT_F411RE -t GCC_ARM --source . -DCHANNEL_PLAN=CP_EU868 --profile=release
$ mbed compile -m MTS_MDOT_F411RE -t GCC_ARM --source . -DCHANNEL_PLAN=CP_GLOBAL --profile=release



Global Channel Plan
------------------
Global Plans support US915, EU868, AU915 and AS923 (1,2,3,4)
AT Commands are used to set the channel plan after loading the firmware.

AT+DFREQ=US915
AT&W
ATZ


Dot libraries
------------------

Include one of the following libraries to complete this project.
  * [libmDot-mbed5](http://github.com/MultiTechSystems/libmDot-mbed5/) -> production-ready build for mDot
  * [libmDot-dev-mbed5](http://github.com/MultiTechSystems/libmDot-dev-mbed5/) -> development build for mDot
  * [libxDot-mbed5](http://github.com/MultiTechSystems/libxDot-mbed5/) -> production-ready build for xDot
  * [libxDot-dev-mbed5](http://github.com/MultiTechSystems/libxDot-dev-mbed5/) -> development build for xDot

A changelog for the Dot library can be found [here](https://developer.mbed.org/teams/MultiTech/wiki/Dot-library-change-log).

LCTT Testing
------------------------------
To compile with LCTT test handling include this macro definitition. This will allow entering test mode with AT+TM!=1. Test mode will be automatically entered after pressing reset, to exit test mode enter + character in command terminal and press reset.

{
    "macros": [
        "MTS_DOT_ENABLE_LORAWAN_TESTMODE=1"
    ]
}




Firmware update over the air
------------------------------
FOTA support can be compiled into this application by adding "FOTA=1" to the macros array in the mbed_app.json file.
FOTA is only supported on the mDot platform, xDot does not have an external flash for supporting FOTA.

{
    "macros": [
        "FOTA=1"
    ]
}
        
