#if defined(MTS_RADIO_CTRL_COMMANDS) && defined(TARGET_XDOT_MAX32670)
#include "CmdInfPreamble.h"

CmdInfPreamble::CmdInfPreamble() :
#if MTS_CMD_TERM_VERBOSE
    Command("TX Infintie Preamble", "AT+INF", "Transmit LoRa Preamble Symbols Indefinitely [(0: stop, 1: start), power, frequency, bandwidth, spreading factor (5-12)]", "(0: stop, 1: start)")
#else
    Command("AT+INF")
#endif
{
    _queryable = true;
}

uint32_t CmdInfPreamble::action(const std::vector<std::string>& args)
{
    uint32_t value;
    if (args.size() == 1)
    {
        CommandTerminal::Serial()->writef("0x%02X\r\n", CommandTerminal::Dot()->getTxInfPreambleMode());
    }
    else if (args.size() == 2)
    {

        if (sscanf(args[1].c_str(), "%" PRIu32, &value) == 1)
        {
            CommandTerminal::Dot()->setTxInfPreambleMode(0, 0, 0, 0, 0);
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::Serial()->writef("Stopping Infinite Preamble\r\n");
#endif
        } else {
            return 1;
        }
    }
    else if (args.size() == 5)
    {
        int frequency;
        int power;
        int bandwidth;
        int spreadingFactor;

        sscanf(args[1].c_str(), "%d", &frequency);
        sscanf(args[2].c_str(), "%d", &power);
        sscanf(args[3].c_str(), "%d", &bandwidth);
        sscanf(args[4].c_str(), "%d", &spreadingFactor);
        CommandTerminal::Dot()->setTxInfPreambleMode(1, frequency, power, bandwidth, uint8_t(spreadingFactor));
    }

    return 0;
}

bool CmdInfPreamble::verify(const std::vector<std::string>& args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        uint32_t value;

        if (sscanf(args[1].c_str(), "%" PRIu32 , &value) != 1) {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument");
#endif
            return false;
        }

        if (uint8_t(value) > 0) {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument");
#endif
            return false;
        }

        return true;
    }

    if(args.size() == 5) {
        uint32_t value;

        // power
        if(sscanf(args[1].c_str(), "%" PRIu32 , &value ) != 1)
        {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument (power)");
#endif
            return false;
        }

        if(value > 22)
        {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument (power)");
#endif
            return false;
        }

        // frequency
        if(sscanf(args[2].c_str(), "%" PRIu32 , &value ) != 1)
        {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument (freq)");
#endif
            return false;
        }

        // bandwidth
        if(sscanf(args[3].c_str(), "%" PRIu32 , &value ) != 1)
        {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument (bandwidth)");
#endif
            return false;
        }

        if (!((value == 500000) || (value == 250000) || (value == 125000)))
        {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument (BW)");
#endif
            return false;
        }

        // spreading factor
        if(sscanf(args[4].c_str(), "%" PRIu32 , &value ) != 1)
        {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument (Spreading Factor)");
#endif
            return false;
        }
        if (value > 0x0C)
        {
#if MTS_CMD_TERM_VERBOSE
            CommandTerminal::setErrorMessage("Invalid argument (Spreading Factor greater than 12)");
#endif
            return false;
        }
        return true;
    }

#if MTS_CMD_TERM_VERBOSE
    CommandTerminal::setErrorMessage("Invalid arguments");
#endif
    return false;
}
#endif //MTS_RADIO_CTRL_COMMANDS