/** Any non-root certificates will have no effect on the SSL client, but will
 * use up extra space for their allocation into the certificate list.
 * Methods for obtaining the Root CA certificate(s) for a website:
 * 1. Open a browser to the target website using HTTPS. 
 *      (These instructions are for Chrome, but should be similar for other browsers)
 *      Click on the lock icon at the beginning of the url, select the "connection" tab,
 *      and click the "certificate information" hyperlink. The browser will open a new window
 *      labeled "Certificate". Switch to the "Certification Path" tab, click the certificate 
 *      closest to the top of the window, then click "View Certificate". This will open a new
 *      window labeled "Certificate" again. This time, click on the "Details" tab, then click 
 *      "Copy to File". This will open a "Certificate Export Wizard". Click next, and choose the 
 *      "Base-64 encoded X.509 (.CER)" option, then click next. Choose the name and location where
 *      you want to save the PEM formatted certificate, then click next, then finish. Open the file
 *      that was created and copy-paste the certificate into this certs.h file. Format the certificate
 *      data so that each line begins with " and is appended with \r\n"
 *
 * 2. Go to https://www.bluessl.com/en/ssltest and enter the website for which you wish to get the root CA
 *      certificates. Click the [Click here to download the public part of this certificate] button located
 *      underneath the certificates that label themselves as Root, or Root CA. The root CA certificate should
 *      self-signed, otherwise it is not the root CA certificate. Take the downloaded file, copy the data
 *      into this certs.h file, and format the data so that each line begins with " and is appended with \r\n"
 *      
 * 3. Using openssl on linux: (Make sure you have openssl installed.) Run the command: openssl s_client
 *      -showcerts -connect <host>:<port> -CApath /etc/ssl/certs
 *      Where <host> is the host name (www.google.com for example), and port is the port on which the connection
 *      will be made (usually 443). When the connection is made with the remote server, the last certificate(s)
 *      listed will be the Root CA certificate(s). Merely copy-paste those certificates into this certs.h file
 *      and format them with each line beginning with " and ending with \r\n"
 */

//Root Certificates
const char CERTIFICATE1[1237] = 
    
    //Nucleus-connect.axeda.com    
    //GeoTrustGlobalCA from GeoTrust website
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIDVDCCAjygAwIBAgIDAjRWMA0GCSqGSIb3DQEBBQUAMEIxCzAJBgNVBAYTAlVT\r\n"
    "MRYwFAYDVQQKEw1HZW9UcnVzdCBJbmMuMRswGQYDVQQDExJHZW9UcnVzdCBHbG9i\r\n"
    "YWwgQ0EwHhcNMDIwNTIxMDQwMDAwWhcNMjIwNTIxMDQwMDAwWjBCMQswCQYDVQQG\r\n"
    "EwJVUzEWMBQGA1UEChMNR2VvVHJ1c3QgSW5jLjEbMBkGA1UEAxMSR2VvVHJ1c3Qg\r\n"
    "R2xvYmFsIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2swYYzD9\r\n"
    "9BcjGlZ+W988bDjkcbd4kdS8odhM+KhDtgPpTSEHCIjaWC9mOSm9BXiLnTjoBbdq\r\n"
    "fnGk5sRgprDvgOSJKA+eJdbtg/OtppHHmMlCGDUUna2YRpIuT8rxh0PBFpVXLVDv\r\n"
    "iS2Aelet8u5fa9IAjbkU+BQVNdnARqN7csiRv8lVK83Qlz6cJmTM386DGXHKTubU\r\n"
    "1XupGc1V3sjs0l44U+VcT4wt/lAjNvxm5suOpDkZALeVAjmRCw7+OC7RHQWa9k0+\r\n"
    "bw8HHa8sHo9gOeL6NlMTOdReJivbPagUvTLrGAMoUgRx5aszPeE4uwc2hGKceeoW\r\n"
    "MPRfwCvocWvk+QIDAQABo1MwUTAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTA\r\n"
    "ephojYn7qwVkDBF9qn1luMrMTjAfBgNVHSMEGDAWgBTAephojYn7qwVkDBF9qn1l\r\n"
    "uMrMTjANBgkqhkiG9w0BAQUFAAOCAQEANeMpauUvXVSOKVCUn5kaFOSPeCpilKIn\r\n"
    "Z57QzxpeR+nBsqTP3UEaBU6bS+5Kb1VSsyShNwrrZHYqLizz/Tt1kL/6cdjHPTfS\r\n"
    "tQWVYrmm3ok9Nns4d0iXrKYgjy6myQzCsplFAMfOEVEiIuCl6rYVSAlk6l5PdPcF\r\n"
    "PseKUgzbFbS9bZvlxrFUaKnjaZC2mqUPuLk/IH2uSrW4nOQdtqvmlKXBx4Ot2/Un\r\n"
    "hw4EbNX/3aBd7YdStysVAq45pmp06drE57xNNB6pXE0zX5IJL4hmXXeXxx12E6nV\r\n"
    "5fEWCRE11azbJHFwLJhWC9kXtNHjUStedejV0NxPNO3CBWaAocvmMw==\r\n"
    "-----END CERTIFICATE-----\r\n";
const char CERTIFICATE2[849] =
    //VeriSignClass3PublicPrimaryCA
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICPDCCAaUCEDyRMcsf9tAbDpq40ES/Er4wDQYJKoZIhvcNAQEFBQAwXzELMAkG\r\n"
    "A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz\r\n"
    "cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2\r\n"
    "MDEyOTAwMDAwMFoXDTI4MDgwMjIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV\r\n"
    "BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt\r\n"
    "YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN\r\n"
    "ADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE\r\n"
    "BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/is\r\n"
    "I19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0G\r\n"
    "CSqGSIb3DQEBBQUAA4GBABByUqkFFBkyCEHwxWsKzH4PIRnN5GfcX6kb5sroc50i\r\n"
    "2JhucwNhkcV8sEVAbkSdjbCxlnRhLQ2pRdKkkirWmnWXbj9T/UWZYB2oK0z5XqcJ\r\n"
    "2HUw19JlYD1n1khVdWk/kfVIC0dpImmClr7JyDiGSnoscxlIaU5rfGW/D/xwzoiQ\r\n"
    "-----END CERTIFICATE-----\r\n";
const char CERTIFICATE3[977] = 
    //Axeda Root CA Certificate
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICmTCCAgICAQAwDQYJKoZIhvcNAQEEBQAwgZQxCzAJBgNVBAYTAlVTMRYwFAYD\r\n"
    "VQQIEw1NYXNzYWNodXNldHRzMRIwEAYDVQQHEwlNYW5zZmllbGQxHDAaBgNVBAoT\r\n"
    "E0F4ZWRhIFN5c3RlbXMsIEluYy4xGTAXBgNVBAMTEEF4ZWRhIFN5c3RlbXMgQ0Ex\r\n"
    "IDAeBgkqhkiG9w0BCQEWEXN1cHBvcnRAYXhlZGEuY29tMB4XDTAzMDExMDE3MzUy\r\n"
    "N1oXDTEzMDEwNzE3MzUyN1owgZQxCzAJBgNVBAYTAlVTMRYwFAYDVQQIEw1NYXNz\r\n"
    "YWNodXNldHRzMRIwEAYDVQQHEwlNYW5zZmllbGQxHDAaBgNVBAoTE0F4ZWRhIFN5\r\n"
    "c3RlbXMsIEluYy4xGTAXBgNVBAMTEEF4ZWRhIFN5c3RlbXMgQ0ExIDAeBgkqhkiG\r\n"
    "9w0BCQEWEXN1cHBvcnRAYXhlZGEuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB\r\n"
    "iQKBgQD0VtQ82SdSI4QTwIWIXTya91GJ4IFZMwY3eXVkg3jpBwGGQFAk2yOAhITZ\r\n"
    "nQkZn5/JEifRJTvLhqq7AtFqkKG0bKza3jLFhMDh4q7nn5en1wWvMWQM8hSA7cBV\r\n"
    "DYbtsRObM8b7TiC8ZlxhN/6fZFiLyzX431Ppx2nSjyfpHK3oSQIDAQABMA0GCSqG\r\n"
    "SIb3DQEBBAUAA4GBAGav/orW9wQ7TvUiJV5IcpckJKQJrTd0M2XBu+iPwJ52+4pP\r\n"
    "SzJJ7zMdhUTEkxuWegz1L25DewZdnMBddtSK9/AcB6l7Ezqwfblr6cuLNduO9+MU\r\n"
    "29I/wb5gbC2vSppa/clLB7Cw/b7ypS+bTTIU9RbbOrtuKtyGGN3YCvXGKUgB\r\n"
    "-----END CERTIFICATE-----\r\n"
    ;