// this program echos on the USB debug port
// it also blinks the RSSI LED on the micro UDK and the D3 LED on the UDK2

#include "mbed.h"

DigitalOut uled(XBEE_RSSI);     // RSSI LED on micro UDK
DigitalOut led(LED1);           // D3 LED on UDK2

Ticker tick;
void tock(void) {
    uled = !uled;
    led = !led;
}

int main() {
    Serial usb(USBTX, USBRX);
    
    tick.attach(&tock, 0.5);
    
    // change the following value to change the baud rate
    usb.baud(115200);
    
    while (true)
        if (usb.readable())
            usb.putc(usb.getc());
}