#include "mbed.h"

/* Simple Hello World program that outputs "Hello World!" every 
    five seconds to the serial debug port, and blinks at the user
    defined hertz
*/

// LED blink rate: higher -> faster blinking
#define LED_BLINK_RATE 1 //Hertz

//Define the LED pin output
DigitalOut led(LED1);
//Define timers
Timer print_timer;
Timer led_timer;

int main() {
    led = 0;                            //Initialize LED off
    print_timer.start();                //Start timers, will count until stopped
    led_timer.start();
    
    while (1) {
        if (print_timer.read() >= 5) {  //print_timer.read() returns time in seconds
            printf("Hello World!\n");
            print_timer.reset();        //Resets timer count to 0
        }
        
        //Calculates interval needed for specified frequency
        if ( led_timer.read_ms() >= (1000.0/(2*LED_BLINK_RATE))) {     
            led = !led;                 //Invert LED output
            led_timer.reset();          //Resets timer count to 0
        }
    }
}