#include "mbed.h"
#include "Cellular.h"
#include "MTSSerialFlowControl.h"

/* This example can be used to check basic network
* connectivity on the cellular network using the
* MTS SocketModem shield. The test connects to the
* network and performs a ping test to Google's DNS.
*/

using namespace mts;

main()
{
    //Setup serial interface to radio
    MTSSerialFlowControl* serial = new MTSSerialFlowControl(PTD3, PTD2, PTA12, PTC8);
    serial->baud(115200);

    //Setup Cellular class
    Cellular* cellular = Cellular::getInstance();
    cellular->init(serial, PTA4, PTC9); //DCD and DTR pins for KL46Z

    //Run status and configuration commands
    printf("\n\r////Start Status and Configuration Commands////\n\r");
    printf("Command Test: %s\n\r", getCodeNames(cellular->test()).c_str()); //Make sure you can talk to the radio
    printf("Signal Strength: %d\n\r", cellular->getSignalStrength()); //Check the signal strength should be above 8
    
    //Makes sure you are reistered with cell
    printf("Registration State: %s\n\r", Cellular::getRegistrationNames(cellular->getRegistration()).c_str()); 
    
    //Shows example of how to send other commands, look at AT command guide for more info
    printf("Send Basic Command (AT): %s\n\r", getCodeNames(cellular->sendBasicCommand("AT", 1000)).c_str());
    printf("Send Command (AT+CSQ): %s\n\r", cellular->sendCommand("AT+CSQ", 1000).c_str());

    //Start Test
    printf("\n\r////Start Network Connectivity Test////\n\r");
    printf("Set APN: %s\n\r", getCodeNames(cellular->setApn("wap.cingular")).c_str()); //Use APN from service provider!!!

    //Setup a data connection
    printf("Attempting to Connect, this may take some time...\n\r");
    while (!cellular->connect()) {
        printf("Failed to connect... Trying again.\n\r");
        wait(1);
    }
    printf("Connected to the Network!\n\r");

    //Try pinging default server "8.8.8.8" (Google's DNS)
    while (true) {
        printf("Ping Valid: %s\n\r", cellular->ping() ? "true" : "false");
        wait(3);
    }
}
