#ifndef TEST_AXEDAWRAPPER_H
#define TEST_AXEDAWRAPPER_H

#include "mbed.h"
#include "AxedaWrapper.h"

// test push(), toString(), clear(), and size() functions
int testAxedaWrapper() {
    using namespace mts;

    int failed = 0;
    std::string data;
    std::string json_data;
    MbedJSONValue json;
    
    std::string serial = "bogus-001";
    AxedaWrapper* client = new AxedaWrapper(serial);
    
    // test size() when map is empty
    if (client->size() != 0) {
        printf("size() failed - empty\n\r");
        failed++;
    }
    
    // test toString() when map is empty
    data = client->toString();
    if (data != "{}") {
        printf("toString() failed - empty\n\r");
        failed++;
    }
    
    // test clear() when map is empty
    client->clear();
    data = client->toString();
    if (data != "{}") {
        printf("clear() failed - empty\n\r");
        failed++;
    }
    
    // test different push() methods (and toString())
    std::string key1 = "key1";
    std::string value1 = "value1";
    client->push(key1, value1);
    json[key1] = value1;
    
    const char* key2 = "key2";
    const char* value2 = "value2";
    client->push(key2, value2);
    json[key2] = value2;
    
    std::string key3 = "key3";
    int value3 = 15;
    client->push(key3, value3);
    json[key3] = value3;
    
    const char* key4 = "key4";
    int value4 = 30;
    client->push(key4, value4);
    json[key4] = value4;
    
    std::string key5 = "key5";
    double value5 = 87.6;
    client->push(key5, value5);
    json[key5] = value5;
    
    const char* key6 = "key6";
    double value6 = 1000.756;
    client->push(key6, value6);
    json[key6] = value6;
    
    std::string key7 = "key7";
    bool value7 = true;
    client->push(key7, value7);
    json[key7] = value7;
    
    std::string key8 = "key8";
    bool value8 = false;
    client->push(key8, value8);
    json[key8] = value8;
    
    data = client->toString();
    json_data = json.serialize();
    if (data != json_data) {
        printf("push() failed\n\r");
        printf("data: %s\n\r", data.c_str());
        printf("json_data: %s\n\r", json_data.c_str());
        failed ++;
    }
    
    // test size() with non-empty map
    if (client->size() != 8) {
        printf("size() failed - not empty\n\r");
        failed++;
    }
    
    // test clear() when map is not empty
    client->clear();
    data = client->toString();
    if (data != "{}" || client->size() != 0) {
        printf("clear() failed - not empty\n\r");
        failed++;
    }
    
    delete client;
    return failed;
}

#endif