#ifndef HTTPJSONTEXT_H_
#define HTTPJSONTEXT_H_

#include "HTTPText.h"

 /** A data endpoint to store text
*/
class HTTPJsonText: public HTTPText
{
public:
    HTTPJsonText(char* arg);
    
protected:
    virtual int getDataType(char* type, size_t maxTypeLen); //Internet media type for Content-Type header
};

HTTPJsonText::HTTPJsonText(char* arg) : HTTPText(arg) {}

/*virtual*/ int HTTPJsonText::getDataType(char* type, size_t maxTypeLen) //Internet media type for Content-Type header
{
    strncpy(type, "application/json", maxTypeLen-1);
    type[maxTypeLen-1] = '\0';
    return 0;
}

#endif /* HTTPJSONTEXT_H_ */