#include "AxedaWrapper.h"
#include "HTTPJsonText.h"
#include <string>
#include <vector>
#include <stdlib.h>

using namespace mts;

static const char* PATH_BASE = "/ammp/data/1/";

AxedaWrapper::AxedaWrapper(const std::string& serial, const std::string& model, const std::string& host, int port) : _timeout(30000) {
    _http_client = new HTTPClient();
    _data = new MbedJSONValue();
    
    char buf[256];
    std::string path = PATH_BASE + model + "!" + serial;
    sprintf(buf, "http://%s:%d%s", host.c_str(), port, path.c_str());
    _url = std::string(buf);
}

AxedaWrapper::~AxedaWrapper() {
    delete _http_client;
    delete _data;
}

void AxedaWrapper::push(const std::string& key, const std::string& value) {
    (*_data)["data"][0]["di"][key] = value;
}

void AxedaWrapper::push(const std::string& key, const char* value) {
    (*_data)["data"][0]["di"][key] = std::string(value);
}

void AxedaWrapper::push(const std::string& key, int value) {
    (*_data)["data"][0]["di"][key] = value;
}

void AxedaWrapper::push(const std::string& key, double value) {
    (*_data)["data"][0]["di"][key] = value;
}

void AxedaWrapper::push(const std::string& key, bool value) {
    (*_data)["data"][0]["di"][key] = value;
}

std::string AxedaWrapper::toString() {
    return size() > 0 ? (*_data)["data"][0]["di"].serialize() : "{}";
}

void AxedaWrapper::clear() {
    if (size()) {
        delete _data;
        _data = new MbedJSONValue();
    }
}

int AxedaWrapper::size() {
    int size = (*_data)["data"][0]["di"].size();
    return size < 0 ? 0 : size;
}

bool AxedaWrapper::send(const std::string& key, const std::string& value) {
    MbedJSONValue data;
    data["data"][0]["di"][key] = value;
    return sendBase(data.serialize());
}

bool AxedaWrapper::send(const std::string& key, const char* value) {
    MbedJSONValue data;
    data["data"][0]["di"][key] = std::string(value);
    return sendBase(data.serialize());
}

bool AxedaWrapper::send(const std::string& key, int value) {
    MbedJSONValue data;
    data["data"][0]["di"][key] = value;
    return sendBase(data.serialize());
}

bool AxedaWrapper::send(const std::string& key, double value) {
    MbedJSONValue data;
    data["data"][0]["di"][key] = value;
    return sendBase(data.serialize());
}

bool AxedaWrapper::sendAll(bool clean) {
    std::string data = _data->serialize();
    bool ret = sendBase(data);
    if (ret && clean) {
        clear();
    }
    return ret;
}

bool AxedaWrapper::sendBase(const std::string& data) {
    int ret;
    char buf[128] = {0};
    HTTPJsonText to_send((char*) data.c_str());
    HTTPText to_recv(buf, sizeof(buf));
    ret = _http_client->post(_url.c_str(), to_send, &to_recv, _timeout);
    if (ret != HTTP_OK) {
        printf("[ERROR] HTTP POST failed\n\r");
        return false;
    } else {
        printf("[INFO] HTTP POST returned %d\r\n", _http_client->getHTTPResponseCode());
    }
    return true;
}