#include "SHT2X.h"

SHT2X::SHT2X(I2C& i2c, Serial& pc) : m_i2c(i2c), m_pc(pc) {
}

int SHT2X::measureTemperature(float *tempC) {
    char command;
    command = SHT_TRIG_TEMP;
    
    m_i2c.write(SHT_I2C_ADDR, &command, 1, false);
    
    wait_ms(100);
    
    char rx[3];
    uint16_t temperature;
    
    m_i2c.read(SHT_I2C_ADDR, rx, 3, false);
    temperature = (rx[0]<<8 | rx[1]);
    temperature += ~0x0003;
//    m_pc.printf(" uint_temp %d \r\n", temperature);
    *tempC = -46.85 + 175.72 * ( ((float) temperature) / 65536 );
    
    return 0;
    
}

int SHT2X::measureHumidty(float *relHumidty) {
    char command;
    command = SHT_TRIG_RH;
    
    m_i2c.write(SHT_I2C_ADDR, &command, 1, false);
    
    wait_ms(100);
    
    char rx[3];
    uint16_t humidity;
    
    m_i2c.read(SHT_I2C_ADDR, rx, 3, false);
    
    humidity = (rx[0]<<8) + rx[1];
    humidity += ~0x0003;
    *relHumidty = -6 + 125 * ( ((float) humidity) / 65536 );
    
    return 0;
    
}

int SHT2X::readData(float *tempC, float *relHumidty) {
    measureTemperature(tempC);
    wait_ms(100);
    measureHumidty(relHumidty);
    return 0;
}

int SHT2X::setPrecision(char precision) {

    char command[2];
    command[0] = SHT_WRITE_REG;
    command[1] = precision;

    return m_i2c.write(SHT_I2C_ADDR, command, 2, false);
    
}

bool SHT2X::softRest() {
    char command = SHT_SOFT_RESET;
    
    if (m_i2c.write(SHT_I2C_ADDR, &command, 1, false) != 0) {
        return false;
    }
    
    return true;
}