/* Copyright (c) 2016 MtM Technology Corporation, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef PAJ7620U2_h
#define PAJ7620U2_h

#include "mbed.h"
 

#define PAJ7620U2_SLAVE_ADDR 0xE6


class PAJ7620U2 {    
public:
    PAJ7620U2(PinName sda, PinName scl, PinName int1 = NC);
    uint16_t ReadIntFlag(void);
    void IntEvent(void(*fptr)(void));

    uint16_t PID;
    uint8_t  VID;

private:
    I2C _i2c;
    InterruptIn _int1;
    
    void RegWrite(char reg, char  val);
    void RegRead (char reg, char *val, int len);
    void RegReadModifyWrite(char reg, char clr_mask, char set_mask);
};

#endif