/* Copyright (c) 2016 MtM Technology Corporation, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef AK09912_H
#define AK09912_H

#include "mbed.h"


#define AK09912_SLAVE_ADDR 0x1A // 0001_1010b


class AK09912 {    
public:
    struct Data {
        float x;    // uT/LSB
        float y;
        float z;
        float t;    // 'C
    };

    static const uint8_t DEVICE_ID = 0x04;

    AK09912(I2C &i2c, PinName int1 = NC);
    
    void ConfigDevice();
    void GetDeviceID(uint8_t *id);
    void GetData(Data *data);
    
private:
    I2C &_i2c;
    InterruptIn _int1;
    
    uint8_t _asa[3]; // ASAX, ASAY, ASAZ

    float ConvertAdcToMagnetic(int16_t adc, uint8_t asa);
    float ConvertAdcToTemperature(uint8_t adc);

    void RegWrite(char reg, char  val);
    void RegRead (char reg, char *val, int len);
    void RegReadModifyWrite(char reg, char clr_mask, char set_mask);
};

#endif