/* Copyright (c) 2016 MtM Technology Corporation, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef AK9750_H
#define AK9750_H

#include "mbed.h"
 

#define AK9750_SLAVE_ADDR 0xC8 // 1100_1000b


class AK9750 {    
public:
    struct Data {
        float ir1;  // pA
        float ir2;
        float ir3;
        float ir4;
        float tmp;  // 'C
    };

    static const uint8_t DEVICE_ID = 0x13;

    /* Interrupts */
    static const unsigned INT_DR    = 0x01; // Data ready
    static const unsigned INT_IR24L = 0x02; // Lower threshold level
    static const unsigned INT_IR24H = 0x04; // Upper threshold level
    static const unsigned INT_IR13L = 0x08; // Lower threshold level
    static const unsigned INT_IR13H = 0x10; // Upper threshold level

public: 
    AK9750(I2C &i2c, PinName int1 = NC);
    
    void ConfigDevice();
    void GetDeviceID(uint8_t *id);
    void GetData(Data *data);
    int32_t GetTriggeredAreaNum(Data *data);
    
    /* Interrupts */
    void    SetIntEvent(uint8_t int_enable, void(*fptr)(void));
    uint8_t GetIntStatus();
    
private:
    I2C &_i2c;
    InterruptIn _int1;
    
    float ConvertAdcToIr(int16_t adc);
    float ConvertAdcToTemperature(int16_t adc);

    void RegWrite(char reg, char  val);
    void RegRead (char reg, char *val, int len);
    void RegReadModifyWrite(char reg, char clr_mask, char set_mask);
};

#endif