/* Copyright (c) 2016 MtM Technology Corporation, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef AK09970_H
#define AK09970_H

#include "mbed.h"
 

#define AK09970_SLAVE_ADDR 0x18 // 0001_1000b


class AK09970 {    
public:
    enum SMR {
        SMR_HighSens  = (0<<5),
        SMR_WideRange = (1<<5),
    };
    
    enum SDR {
        SDR_LowNoise = (0<<4),
        SDR_LowPower = (1<<4),
    };
    
    enum Mode {
        Mode_PowerDown = 0,
        Mode_Single,
        Mode_1_0p25Hz,
        Mode_2_0p5Hz   = 4,
        Mode_3_1Hz     = 6,
        Mode_4_10Hz    = 8,
        Mode_5_20Hz    = 10,
        Mode_6_50Hz    = 12,
        Mode_7_100Hz   = 14,
    };

    struct Data {
        float x;    // uT/LSB
        float y;
        float z;
    };

    static const uint8_t DEVICE_ID = 0xC0;

    AK09970(I2C &i2c, PinName int1 = NC);
    
    void ConfigDevice(uint8_t mode = SMR_HighSens | SDR_LowNoise | Mode_1_0p25Hz);
    void GetDeviceID(uint8_t *id);
    void GetData(Data *data);
    
private:
    I2C &_i2c;
    InterruptIn _int1;
    
    float _sensitivity;

    float ConvertAdcToMagnetic(int16_t adc);

    void RegWrite(char reg, char val);
    void RegWrite(char reg, char *val, int len);
    void RegRead (char reg, char *val, int len);
    void RegReadModifyWrite(char reg, char clr_mask, char set_mask);
};

#endif