#ifndef MTSENSE01_H
#define MTSENSE01_H

#include "mbed.h"
#include "BMP280.h"
#include "SHT2X.h"

class MtSense01 {
    public:
        MtSense01(I2C& i2c, Serial& pc);
        int Initial();
        int readData(float* pTemperature = NULL, int* pPressure = NULL, float* pHumidity = NULL);
        float getTemperature();
        float getPressure();
        float getHumidity();
        
    protected:
        SHT2X   sht21;
        BMP280  bmp280;
    private:
        
};

#endif