#include "MtSense01.h"

MtSense01::MtSense01(I2C& i2c, Serial& pc): sht21(i2c, pc), bmp280(i2c) {
}

int MtSense01::Initial() {
    
    bmp280.init();
    
    return 0;
}

int MtSense01::readData(float* pTemperature, int* pPressure, float* pHumidity) {
    
    bmp280.readData(pTemperature, pPressure);
    wait_ms(50);
    sht21.readData(pTemperature, pHumidity);
    
    return 0;    
}
