#ifndef __DEBUG_H__
#define __DEBUG_H__

#include "Serial.h"


#define ENABLE_LOG      1
#define ENABLE_ASSERT   1

extern Serial dbg;


#if ENABLE_LOG
#define log(...) dbg.printf(__VA_ARGS__)
#else
#define log(...)
#endif

#if ENABLE_ASSERT
#define assert(expr) { \
    if (!(expr)) { \
        dbg.printf("ASSERT: %s, file %s, line %d\n", #expr, __FILE__, __LINE__); \
        while(1); \
    } \
}
#else
#define assert(expr)
#endif


#endif

