#ifndef ENVIRONMENTALUVSERVICE_H
#define ENVIRONMENTALUVSERVICE_H

#include "ble/BLE.h"

class EnvironmentUVService {
     public:
     
        typedef int UVType_t;
        EnvironmentUVService(BLE& _ble) : 
            ble(_ble),
            uvCharacteristic(0x2A76, &uv ) {
                
                static bool serviceAdded = false; /* We should only ever need to add the information service once. */
                if (serviceAdded) {
                    return;
                }
        
                GattCharacteristic *charTable[] = { &uvCharacteristic };
        
                GattService environmentalService(GattService::UUID_ENVIRONMENTAL_SERVICE, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        
                ble.gattServer().addService(environmentalService);
                serviceAdded = true;     
            }
            
        void updateTemperature(int uvIndex) {
            uv = (UVType_t) uvIndex;
            ble.gattServer().write(uvCharacteristic.getValueHandle(), (uint8_t *) &uv, sizeof(UVType_t));
        }
        
    private:
    
        BLE& ble;
        UVType_t uv;
        ReadOnlyGattCharacteristic<UVType_t> uvCharacteristic;
};


#endif