#ifndef AIRQUALITYSERVICE_H
#define AIRQUALITYSERVICE_H

#include "ble/BLE.h"

class AirQualityService {
    public:
        typedef uint16_t CO2Type_t;
        typedef uint16_t TVOCType_t;
        AirQualityService(BLE& _ble, UUID co2CID, UUID tvocCID) : 
            ble(_ble),
            co2Characteristic (co2CID, &co2, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
            tvocCharacteristic(tvocCID, &tvoc, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
                
                uint8_t AQSID[16] = {   '@', 'M', 'T', 'M',
                                        'C', 'O', '2', 'A',
                                        'N', 'D', 'T', 'V',
                                        'O', 'C',  '@',  '@',
                                    };
                                        
                static bool serviceAdded = false; /* We should only ever need to add the information service once. */
                UUID customUUID(AQSID);
                
                if (serviceAdded) {
                    return;
                }
        
                GattCharacteristic *charTable[] = { &co2Characteristic, &tvocCharacteristic };
        
                GattService customAQService(customUUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        
                ble.gattServer().addService(customAQService);
                serviceAdded = true;   
                
        }
        
        void updateCO2(uint16_t co2ppm) {
            co2 = (CO2Type_t) co2ppm;
            ble.gattServer().write(co2Characteristic.getValueHandle(), (uint8_t *) &co2, sizeof(CO2Type_t));
        }
        
        void updateTVOC(uint16_t tvocppb) {
            tvoc = (TVOCType_t) tvocppb;
            ble.gattServer().write(tvocCharacteristic.getValueHandle(), (uint8_t *) &tvoc, sizeof(TVOCType_t));
        }
    
    private:
        BLE&        ble;
        CO2Type_t   co2;
        TVOCType_t  tvoc;
        ReadOnlyGattCharacteristic<CO2Type_t>   co2Characteristic;
        ReadOnlyGattCharacteristic<TVOCType_t>  tvocCharacteristic;
};

#endif