#include "CM3592.h"

CM3592::CM3592(I2C& i2c) : m_i2c(i2c) {
        config[0] = 0x00;   //default LSB set 60ms integration.
        config[1] = 0x82;   //default MSB set Hight Sensitivity and High Dynamic Range.
}

int CM3592::init() {
    
//    char data[3] = { CM3592_REG_CTRL, config[0], config[1]};    
//    m_i2c.write(CM3592_ADDR, data, 3, false);
    
    write(CM3592_REG_CTRL, config);
    
    
    return 0;
}

int CM3592::init(char configL, char configH) {
  
    config[0] = configL;
    config[1] = configH;
    write(CM3592_REG_CTRL, config);
    
    return 0;
    
}

int CM3592::readData(uint16_t *uv) {
    
    char uv_raw[2];
    
    read(CM3592_REG_UV_DATA, uv_raw);
    
    *uv = uv_raw[1]<<8 | uv_raw[0];
    
    return 0;
}

int CM3592::getUVIndex(uint16_t uv) {
    if(uv<747){
        return 0;
    }else if(uv>=747 && uv<1494){
        return 1;
    }else if(uv>=1494 && uv<2442){
        return 2;
    }else if(uv>=2442 && uv<3188){
        return 3;
    }else if(uv>=3188 && uv<3735){
        return 4;
    }else if(uv>=3735 && uv<4483){
        return 5;
    }else if(uv>=4483 && uv<5229){
        return 6;
    }else if(uv>=5229 && uv<5977){
        return 7;
    }else if(uv>=5977 && uv<6724){
        return 8;
    }else if(uv>=6724 && uv<7471){
        return 9;
    }else if(uv>=7471 && uv<8218){
        return 10;
    }else{
        return 10;
    }
}

void CM3592::write(char reg, char data[]) {
    char send[3];
    send[0] = reg;
    send[1] = data[0];
    send[2] = data[1];
    m_i2c.write(CM3592_ADDR, send, 3, false);
}

void CM3592::read(char reg, char data[]) {
    m_i2c.write(CM3592_ADDR, &reg, 1, false);
    m_i2c.read(CM3592_ADDR, data, 2, false);
    
    m_i2c.write(CM3592_ADDR, &reg, 1, false);
//    i2c.read(addr, rx, 2, false);
}
