#ifndef CM3592_H
#define CM3592_H

#define CM3592_ADDR                     0x20

#define CM3592_REG_CTRL                 0x00
#define CM3592_REG_ALS_HIGH_THRESHOLD   0x02
#define CM3592_REG_ALS_LOW_THRESHOLD    0x03
#define CM3592_REG_UV_DATA              0x06
#define CM3592_REG_UVB_DATA             0x07
#define CM3592_REG_G_DATA               0x09
#define CM3592_REG_IR_DATA              0x0B
#define CM3592_REG_DEVICE_ID            0x0C
#define CM3592_REG_ALS_CROSS_INT_EVENT  0x0D

#include "mbed.h"

class CM3592 {
    public:
        CM3592(I2C& i2c);
        int init();
        int init(char configL, char configH);
        int readData(uint16_t *uv);
        int getUVIndex(uint16_t uv);
    protected:
        I2C m_i2c;
        char config[2];
        void write(char reg, char data[]);
        void read(char reg, char data[]);
    private:

};

#endif