#ifndef BMP280_H
#define BMP280_H

// Register define
#define BMP280_ADDR             0xEE    // BMP280 i2c address

#define BMP280_REG_CALIBRATION  0x88    // calibration register start
#define BMP280_REG_ID           0xD0    // read out is 0x58
#define BMP280_REG_RESET        0xE0    // write value 0xB6 will process power-on-reset other value is not work
#define BMP280_REG_STATUS       0xF3    // indicate status of the device
#define BMP280_REG_CTRL_MEAS    0xF4    // config options of the device
#define BMP280_REG_CONFIG       0xF5    // set rate, filted and interface options of device
#define BMP280_REG_PRESS        0xF7    // pressure measurement out data 0xF7~0xF9
#define BMP280_REG_TMEP         0xFA    // temperature measurment out data 0xFA~0xFC

// OSSR Data
#define BMP280_OSSR_SKIP        0x00    // Skipped output set to 0x80000
#define BMP280_OSSR_OV1         0x01    // oversampling x1
#define BMP280_OSSR_OV2         0x02    // oversampling x2
#define BMP280_OSSR_OV4         0x03    // oversampling x4
#define BMP280_OSSR_OV8         0x04    // oversampling x8
#define BMP280_OSSR_OV16        0x05    // oversampling x16

// wait to read out time
// T_SB
#define BMP280_T_SB0            0x00    // 0.5ms
#define BMP280_T_SB62           0x01    // 62.5ms
#define BMP280_T_SB125          0x02    // 125ms
#define BMP280_T_SB250          0x03    // 250ms
#define BMP280_T_SB500          0x04    // 500ms
#define BMP280_T_SB1000         0x05    // 1000ms
#define BMP280_T_SB2000         0x06    // 2000ms
#define BMP280_T_SB4000         0x07    // 4000ms

// Power Mode
#define BMP280_POWER_SLEEP      0b00
#define BMP280_POWER_FORCE      0b01
#define BMP280_POWER_NORMAL     0b11



#include "mbed.h"

class BMP280 {
    
    public:
        BMP280(I2C& i2c);
        int init(char ctrl_meas  = 0x6F, char config = 0x70);
        int readData(float *tempC, int *pressPa);
        
    protected:
        I2C m_i2c;
        Serial pc;
        unsigned short dig_T1,dig_P1;
        short dig_T2,dig_T3,dig_P2,dig_P3,dig_P4,dig_P5,dig_P6,dig_P7,dig_P8,dig_P9;
        void write(char reg, char ctrl);
        void read(char reg, char *data, int length);
        
    private:
    
};

#endif