#include "BMP280.h"

void BMP280::write(char reg, char ctrl) {
    char data[2] = {reg, ctrl};
    m_i2c.write(BMP280_ADDR, data, 2, false);
}

void BMP280::read(char reg, char *data, int length) {
    m_i2c.write(BMP280_ADDR, &reg, 1, false);
    m_i2c.read(BMP280_ADDR+1, data, length, false);
}

BMP280::BMP280(I2C& i2c) : m_i2c(i2c), pc(p5,p4) {
    char begin = BMP280_REG_CALIBRATION;
    char bf[24];
    
    read(begin, bf, 24);
    dig_T1 = (bf[1]<<8) | bf[0];
    dig_T2 = (bf[3]<<8) | bf[2];
    dig_T3 = (bf[5]<<8) | bf[4];
    dig_P1 = (bf[7]<<8) | bf[6];
    dig_P2 = (bf[9]<<8) | bf[8];
    dig_P3 = (bf[11]<<8) | bf[10];
    dig_P4 = (bf[13]<<8) | bf[12];
    dig_P5 = (bf[15]<<8) | bf[14];
    dig_P6 = (bf[17]<<8) | bf[16];
    dig_P7 = (bf[19]<<8) | bf[18];
    dig_P8 = (bf[21]<<8) | bf[20];
    dig_P9 = (bf[23]<<8) | bf[22];
    

}

int BMP280::init(char ctrl_meas , char config) {
    
    char reg_ctrl, reg_config;
    reg_ctrl = BMP280_REG_CTRL_MEAS;
    reg_config = BMP280_REG_CONFIG;
    
    write(reg_ctrl,   ctrl_meas);
    write(reg_config, config);
    
//    pc.printf("t1:%d, t2:%d, t3:%d\r\n", dig_T1, dig_T2, dig_T3);
//    pc.printf("p1:%d, p2:%d, p3:%d, p4:%d, p5:%d, p6:%d, p7:%d, p8:%d, p9:%d\r\n", dig_P1, dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9);
    
    return 0;
}

int BMP280::readData(float *tempC, int *pressPa) {
    
    int var1,var2,T;
    int t_fine;
    unsigned int press=0;
    char read_reg = BMP280_REG_PRESS;
    char rx[6];
    int adc_T,adc_P;
    
    read(read_reg, rx, 6);
    
    adc_T = ((rx[3]<<12)|(rx[4]<<4)|rx[5]>>4);
    adc_P = ((rx[0]<<12)|(rx[1]<<4)|rx[2]>>4);
//    pc.printf("adc_T %d, adc_p %d\r\n", adc_T, adc_P);
    
    var1=((((adc_T>>3)-((int)dig_T1<<1)))*((int)dig_T2))>>11;
    var2=(((((adc_T>>4)-((int)dig_T1))*((adc_T>>4)-((int)dig_T1)))>>12)*((int)dig_T3))>>14;
    t_fine=var1+var2;
    T=(t_fine*5+128)>>8;
    *tempC = T/100.0;
//    pc.printf("BMP280 T %d\r\n", T);

 
    var1 = (t_fine >> 1) - 64000;
    var2 = (((var1 >> 2) * (var1 >> 2)) >> 11) * dig_P6;
    var2 = var2 + ((var1 * dig_P5) << 1);
    var2 = (var2 >> 2) + (dig_P4 << 16);
    var1 = (((dig_P3 * (((var1 >> 2)*(var1 >> 2)) >> 13)) >> 3) + ((dig_P2 * var1) >> 1)) >> 18;
    var1 = ((32768 + var1) * dig_P1) >> 15;
    if (var1 == 0) {
//        pc.printf("var1 is zero!\r\n");
    }
    press = (((1048576 - adc_P) - (var2 >> 12))) * 3125;
    if(press < 0x80000000) {
        press = (press << 1) / var1;
    } else {
        press = (press / var1) * 2;
    }
    var1 = ((int32_t)dig_P9 * ((int32_t)(((press >> 3) * (press >> 3)) >> 13))) >> 12;
    var2 = (((int32_t)(press >> 2)) * (int32_t)dig_P8) >> 13;
    press = (press + ((var1 + var2 + dig_P7) >> 4));
    *pressPa = press;
//    pc.printf("press is %d\r\n", press);
    
    return 0;
}