/* Copyright (c) 2016 MtM Technology Corporation, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef BMG160_h
#define BMG160_h

#include "mbed.h"

#define BMG160_SLAVE_ADDR 0xd0

class BMG160 {    
public:
    BMG160(PinName i2c_sda, PinName i2c_scl, PinName int1 = NC, PinName int2 = NC, uint8_t range = 0x00, uint8_t bandwith = 0x00);
    void ReadXYZ(int16_t *xyz);
    
private:
    I2C i2c_;
    PinName interrupt1_pinname_;
    InterruptIn interrupt1_;
    PinName interrupt2_pinname_;
    InterruptIn interrupt2_;
    uint8_t range_;
    uint8_t bandwith_;
    
    void RegWrite(char reg, char  val);
    void RegRead (char reg, char *val, int len);
};

#endif