/* Copyright (c) 2016 MtM Technology Corporation, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "BMG160.h"

/******************************* 
 * Public methods
 *******************************/
BMG160::BMG160(PinName i2c_sda, PinName i2c_scl, PinName interrupt1_pinname, PinName interrupt2_pinname,uint8_t range, uint8_t bandwith)
    : i2c_(i2c_sda, i2c_scl), 
      interrupt1_pinname_(interrupt1_pinname),
      interrupt1_(interrupt1_pinname),
      interrupt2_pinname_(interrupt2_pinname),  
      interrupt2_(interrupt2_pinname),
      range_(range), bandwith_(bandwith) {
          
    /* Basic */
    RegWrite(0x10, bandwith_);  // bandwidth
    RegWrite(0x0F, range_);     // range
    RegWrite(0x1A, 0x20);       // slow_offset_unfilt = 1 
    RegWrite(0x31, 0x07);      // SOC_REG slow_offset_en_x/y/z = 1
   
}

void BMG160::ReadXYZ(int16_t *xyz) {
    char val[6];

    /* Read raw data */
    RegRead(0x02, val, sizeof(val));
    xyz[0] = ((int16_t)val[1] << 8) | (val[0] & 0xC0);
    xyz[1] = ((int16_t)val[3] << 8) | (val[2] & 0xC0);
    xyz[2] = ((int16_t)val[5] << 8) | (val[4] & 0xC0);

    /* Align right */
    xyz[0] >>= 6;
    xyz[1] >>= 6;
    xyz[2] >>= 6;
}
/******************************* 
 * Private methods
 *******************************/
void BMG160::RegWrite(char reg, char val) {
    char data[2];
    data[0] = reg;
    data[1] = val;
    i2c_.write(BMG160_SLAVE_ADDR, data, 2, 0);
}

void BMG160::RegRead(char reg, char *val, int len) {
    i2c_.write(BMG160_SLAVE_ADDR, &reg, 1, 0);
    i2c_.read (BMG160_SLAVE_ADDR, val, len);
}