#include "mbed.h"
#include "Adafruit_ADS1015.h"
#include "KXTJ3.h"

#define SERIAL_BAUD_RATE    230400
#define ADC_MAX_VALUE       2048
#define DYNAMIC_SCALE       0.6f
// READOUT_FREQ should work up to around 200 I think
#define READOUT_FREQ        120
//
 
I2C i2c(PC_9, PA_8);
Adafruit_ADS1115 piezo_resistive_adc1(&i2c, 0x48);   // first PiëzoResistive ADC
Adafruit_ADS1115 piezo_resistive_adc2(&i2c, 0x49);   // second PiëzoResistive ADC
Adafruit_ADS1115 piezo_electric_adc(&i2c, 0x4B);
Adafruit_ADS1115 piezo_electric_adc2(&i2c, 0x4A);
KXTJ3 accelero(&i2c);
adsGain_t pga_table[]= {GAIN_SIXTEEN,GAIN_EIGHT,GAIN_FOUR,GAIN_TWO,GAIN_ONE};
//Serial pc(PC_12, PD_2); // debug tx, rx
Serial pc(PB_10, PC_5); // RS232 tx, rx
Ticker sample;
int16_t res[8] = {0,0,0,0,0,0,0,0};   // 8 PR sensors 1 time per cycle
uint8_t scaler_res[8] = {1,1,1,1,1,1,1,1};   // 8 PR sensors 1 time per cycle
int ele[6] = {0,0,0,0,0,0};   // 8 PR sensors 1 time per cycle
uint8_t scaler_ele[6] = {1,1,1,1,1,1};   // 8 PR sensors 1 time per cycle
//short read[10];
float accelerometer_data[3];
int accelerometer_zaxis;


int channel_electric=0;
int channel_resistive=0;
int sample_period;

Timer times;
Timer total_time;

uint8_t determineNextGain(int last_sample)
{
    if(last_sample<0) {
        last_sample=abs(last_sample);
    }
    uint8_t gain_factor=0;
    uint8_t result=1;
    uint16_t sample_normalized=last_sample/ADC_MAX_VALUE;//! determine what would have been the ideal gain setting of the last sample
    for(uint8_t i=0; i<5; i++) {//! Find the highest power of two in the number (all gain settings are powers of two)
        if(sample_normalized&(1<<i)) {
            gain_factor=i+1;
        }
    }
    for(uint8_t i=0; i<gain_factor; i++)result*=2;//! 2^(gain_factor)
    if(((result*ADC_MAX_VALUE)-last_sample)<(DYNAMIC_SCALE*(result*ADC_MAX_VALUE/2)))gain_factor++;//! If the last sample was closer to the max value of the ideal gain setting than the threshold take one gain setting broader
    if(gain_factor>4)gain_factor=4;
    return gain_factor;
}

void getSingleResistive()
{
    if(channel_resistive>3)return;//! make sure it is a valid channel
    uint8_t pga_gain=determineNextGain(res[(channel_resistive+1)%4]);//! calculate pga setting for the next sample conversion of that adc
    scaler_res[(channel_resistive+1)%4]=16;
    for(uint8_t i=0; i<pga_gain; i++)scaler_res[(channel_resistive+1)%4]/=2; //! Update the scaler to correctly process the gain setting of the incoming adc value later on
    piezo_resistive_adc1.setGain(pga_table[pga_gain]);//! Set pga for the next sample conversion
    res[channel_resistive]=piezo_resistive_adc1.readADC_SingleEnded(((channel_resistive+1)%4))/scaler_res[channel_resistive];//! Readout sample and start next conversion

    //! same as above but for the other PR ADC
    pga_gain=determineNextGain(res[((channel_resistive+1)%4)+4]);
    scaler_res[((channel_resistive+1)%4)+4]=16;
    for(uint8_t i=0; i<pga_gain; i++)scaler_res[((channel_resistive+1)%4)+4]/=2;
    piezo_resistive_adc2.setGain(pga_table[pga_gain]);
    res[channel_resistive+4]=piezo_resistive_adc2.readADC_SingleEnded(((channel_resistive+1)%4))/scaler_res[channel_resistive+4];
    channel_resistive=(channel_resistive+1)%4;
}

void getSingleElectric()
{

    //! Same as getResistive but for the PE ADCs
    if(channel_electric>2) {
        channel_electric=(channel_electric+1)%4;
        return;//! Make sure it is a valid channel
    }
    uint8_t pga_gain=determineNextGain(ele[(channel_electric+1)%3]);
    scaler_ele[(channel_electric+1)%3]=16;
    for(uint8_t i=0; i<pga_gain; i++)scaler_ele[(channel_electric+1)%3]/=2;
    piezo_electric_adc.setGain(pga_table[pga_gain]);
    ele[channel_electric]=piezo_electric_adc.readADC_Differential((channel_electric+1)%3)/scaler_ele[channel_electric];

    //2nd adc

    pga_gain=determineNextGain(ele[((channel_electric+1)%3)+3]);
    scaler_ele[((channel_electric+1)%3)+3]=16;
    for(uint8_t i=0; i<pga_gain; i++)scaler_ele[((channel_electric+1)%3)+3]/=2;
    piezo_electric_adc2.setGain(pga_table[pga_gain]);
    ele[channel_electric+3]=piezo_electric_adc2.readADC_Differential((channel_electric+1)%3)/scaler_ele[channel_electric+3];


    channel_electric=(channel_electric+1)%4;
}

void read_all_adc_single_channel()
{
    getSingleElectric();
    getSingleResistive();
}

void read_adc()
{
    times.reset();
    times.start();
    //if(boobs.read() > 0.5) {
       // p++;
        //stamp = total_time.read_ms();
        for (int i=0; i<4; i++) {
            read_all_adc_single_channel();
            wait_us(450);
        }
            accelero.initialize();
            accelero.getAccAllAxis(accelerometer_data);
            accelerometer_zaxis=int(accelerometer_data[2]*1000);

        pc.printf("%5d,%5d,%5d,%5d,", res[0], res[1], res[2], res[3]);
        pc.printf("%5d,%5d,%5d,%5d,", res[4], res[5], res[6], res[7]);
        //pc.printf("%d,%d,%d,%d,", scaler_res[0], scaler_res[1], scaler_res[2], scaler_res[3]);
        //pc.printf("%d,%d,%d,%d,", scaler_res[4], scaler_res[5], scaler_res[6], scaler_res[7]);
        pc.printf("%6d,%6d,%6d,", ele[0],ele[1],ele[2]);
        pc.printf("%6d,%6d,%6d,", ele[3],ele[4],ele[5]);
        //pc.printf("%d,%d,%d,",scaler_ele[0],scaler_ele[1],scaler_ele[2]);
        //pc.printf("%d,%d,%d,",scaler_ele[3],scaler_ele[4],scaler_ele[5]);
        pc.printf("%3d,",accelerometer_zaxis);
//        pc.printf("%d,%d,",p,stamp);
        pc.printf("\r");
        pc.printf("\n");
    
    while(times.read_us()<sample_period) {}
}

void noise()
{
    uint8_t pga_gain=determineNextGain(ele[4]);
    scaler_ele[4]=16;
    for(uint8_t i=0; i<pga_gain; i++)scaler_ele[4]/=2;
    piezo_electric_adc2.setGain(pga_table[pga_gain]);
    ele[4]=piezo_electric_adc2.readADC_Differential(1)/scaler_ele[4];
    pc.printf("%d\n",ele[4]);
}

int main()
{
    sample_period=1000000/READOUT_FREQ;
    i2c.frequency(400000);
    pc.baud(SERIAL_BAUD_RATE);
    //sample.attach_us(&read_adc, sample_period);
    //sample.attach_us(&noise, 500);
    
    //total_time.start();
    
    while (1) {
        read_adc();
        
    }
}