#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"
#include "SDFileSystem.h"
#include <ds3231.h>

#define WS2812_BUF 32
#define NUM_COLORS 7
#define NUM_LEDS_PER_COLOR 32

PixelArray px(WS2812_BUF);
WS2812 ws(PB_9, WS2812_BUF, 10, 36, 20, 36);

Ds3231 rtc(PB_7, PB_8);

SDFileSystem sd(PC_12,PC_11,PC_10,PA_15, "sd", NC, SDFileSystem::SWITCH_NONE, 400000);
RawSerial pc(PA_9,PA_10);

int i = 0;
int r,g,b,y,w;

AnalogIn analog_value(PC_0);
float meas;

DigitalOut Led0 (PA_4);
DigitalOut Led1 (PA_5);
DigitalOut Led2 (PA_6);
DigitalOut Led3 (PA_7);
DigitalOut Led4 (PC_4);

ds3231_time_t Time = {12, 0, 0, 1, 0}; 
uint16_t rtn_val;
uint32_t SetTime;
uint32_t GetTime;

char TestCase = 'A';

int main()
{
    pc.baud(115200);
    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    pc.format(8, SerialBase::None, 1);
    
    switch(TestCase){
        case 'A':
            pc.printf("Programming succesfull\n");
            TestCase = 'B';
            wait(0.2);
        case 'B':
            pc.printf("\nTesting Serial communication.....\n");
            wait(0.2);
            pc.printf("\tTransmit to PC Succesfull\n");
            TestCase = 'C';
        case 'C':
            pc.printf("\nTesting Touch-Pad connections...\n");
            wait(0.2);
            
            TestCase = 'D';
        case 'D':
            pc.printf("\nTesting LDR connectivity\n");
            for(int j; j < 5; j++){
                meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
                meas = meas * 3300; // Change the value to be in the 0 to 3300 range
                pc.printf("\tMeasurement = %.0f mV\n", meas);
                wait(0.2);
            }
            TestCase = 'E';
        case 'E':
            pc.printf("\nTesting Protocol Led...\n");
            wait(0.2);
            pc.printf("\tLeds blinking 10 times\n");
            for(int z; z < 10; z++){
                Led0 = 1;
                Led1 = 1;
                Led2 = 1;
                Led3 = 1;
                Led4 = 1;
                wait(0.2);
                Led0 = 0;
                Led1 = 0;
                Led2 = 0;
                Led3 = 0;
                Led4 = 0;
                wait(0.2);
            }
            TestCase = 'F';
        case 'F':
            pc.printf("\nTesting Led Ring...\n");   
            TestCase = 'G';
        case 'G':
            pc.printf("\nTesting SD-Card slot...\n");
            //Make sure a card is present
            if (!sd.card_present()) {
                pc.printf("\nNo card present!\n");
            }

            //Try to mount the SD card
            pc.printf("\nMounting SD card...");
            if (sd.mount() != 0) {
                pc.printf("failed!\n");
            }
            pc.printf("success!\n");

            //Display the card type
            pc.printf("\tCard type: ");
            SDFileSystem::CardType cardType = sd.card_type();
            if (cardType == SDFileSystem::CARD_NONE)
                pc.printf("None\n");
            else if (cardType == SDFileSystem::CARD_MMC)
                pc.printf("MMC\n");
            else if (cardType == SDFileSystem::CARD_SD)
                pc.printf("SD\n");
            else if (cardType == SDFileSystem::CARD_SDHC)
                pc.printf("SDHC\n");
            else
                pc.printf("Unknown\n");

            //Display the card capacity
            pc.printf("\tSectors: %u\n", sd.disk_sectors());
            pc.printf("\tCapacity: %.1fMB\n", sd.disk_sectors() / 2048.0);

            //Unmount the SD card
            sd.unmount();
            TestCase = 'H';
        case 'H':
            pc.printf("\nTesting RTC...\n");
            pc.printf("Setting Time...\n");
            rtn_val = rtc.set_time(Time);
            if (rtn_val == 0){
                pc.printf("\tDone\n");
                pc.printf("Repeating for 5 Seconds\n");
                }
            else{
                pc.printf("Setting Time Failed");
            }
            rtn_val = rtc.get_time(&Time);
            pc.printf("\tTime = %u\n", Time);
            wait(1);
            rtn_val = rtc.get_time(&Time);
            pc.printf("\tTime = %u\n", Time);
            wait(1);
            rtn_val = rtc.get_time(&Time);
            pc.printf("\tTime = %u\n", Time);
            wait(1);
            rtn_val = rtc.get_time(&Time);
            pc.printf("\tTime = %u\n", Time);
            wait(1);
            rtn_val = rtc.get_time(&Time);
            pc.printf("\tTime = %u\n", Time);
            wait(1);
           
            pc.printf("RTC Test Succesfull\n");
            break;
        default:
            pc.printf("Error while testing...\n");
        }
    
    pc.printf("\nAll test executed...\n");
    
    ws.useII(WS2812::GLOBAL); // use per-pixel intensity scaling
    
    //// set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {0xff0000,0x0000ff,0xffa500,0x555555,0x800080,0x000000}; //r b y w p off
    r = 0;
    g = 1;
    b = 2;
    y = 3;
    w = 4;
//    // for each of the colours (j) write out 10 of them
//    // the pixels are written at the colour*10, plus the colour position
//    // all modulus 60 so it wraps around
    ws.setII(60);
//    // Now the buffer is written, rotate it
//    // by writing it out with an increasing offset
    while (1) {
        ws.setII(90); //intensity level (max = 255)
        for(int j=0; j<6; j++) {
            px.SetAll(colorbuf[j%7]);
            for(int k = 1; k<32; k = k+2) {
                px.Set(k, colorbuf[6]);
            }
            ws.write_offsets(px.getBuf(),0,0,0);
            wait(3);
        }

        ws.setII(25);
        for(int j=0; j<6; j++) {
            px.SetAll(colorbuf[j%7]);
            ws.write_offsets(px.getBuf(),0,0,0);
            wait(3);
        }

        ws.setII(60);
        for(int j=0; j<6; j++) {
            px.SetAll(colorbuf[j%7]);
            ws.write_offsets(px.getBuf(),0,0,0);
            wait(3);
        }


        ws.setII(180);
        for(int j=0; j<6; j++) {
            px.SetAll(colorbuf[j%7]);
            ws.write_offsets(px.getBuf(),0,0,0);
            wait(3);
        }


       ws.setII(60);
        for(int j=0; j<6; j++) {
            px.SetAll(colorbuf[j%7]);
            for(int k = 10; k<32; k++) {
                px.Set(k, colorbuf[6]);
            }
            ws.write_offsets(px.getBuf(),0,0,0);
            wait(3);
        }
        wait(5);
    }
}
