//Including the needed libraries
#include "mbed.h"
#include "Adafruit_ADS1015.h"
#include "USBSerial.h" 

//Not sure if we need those?
#define SERIAL_BAUD_RATE    115200
#define ADC_MAX_VALUE       2048

//Defining the I2C port connections
I2C i2c(PB_9,PB_8);

//Defining the goto adress for the ADC
Adafruit_ADS1015 adc(&i2c, 0x48);

//Serial pc(USBTX, USBRX);

//Setting i2c frequency and baudrate
int i2c__frequency = 100000;
int baud_rate = 115200;

//Variables
int adc0;
int dataset[10];
int i;
int sum;
int average_val;


//Input/Output
DigitalOut myled(LED1);
Serial usb(SERIAL_TX, SERIAL_RX);
DigitalIn push(PC_13);

//Main code
int main()
{
    //Setting the baudrate
    usb.baud(baud_rate);
    //adc.setGain(GAIN_SIXTEEN);

    while(1) {
        //Test code
        //for(i=0; i< 10; i++){
            //dataset[i] = ldr.readADC_Differential(0);
            //sum += dataset[i];
            //}
        //average_val = sum/10;
        
        
        //Getting digital value from ADC
        adc0 = adc.readADC_Differential(0);
        
        //Printing digital value from ADC
        usb.printf("%+.5d", adc0); //place adc0 if test code doesn't work
        usb.printf("\r");
        usb.printf("\n");
        myled = 1;
        
        //Turn-off led when button gets pushed
        if(push == 0) {
            myled = 0;
        }
    }
}
