//Including the needed libraries
#include "mbed.h"
#include "Adafruit_ADS1015.h"
#include "USBSerial.h" 
#include "stdio.h"

//Not sure if we need those?
#define SERIAL_BAUD_RATE    115200
#define ADC_MAX_VALUE       2048

//Defining the I2C and Serial port connections
I2C i2c(p28,p27);
Serial pc(USBTX, USBRX);

//Defining the goto adress for the ADC
Adafruit_ADS1115 adc(&i2c, 0x48);
Adafruit_ADS1115 adc2(&i2c, 0x49);

//Setting i2c frequency and baudrate
int i2c__frequency = 100000;
int baud_rate = 115200;

//Declair var
int ledPin = 0;
int listFSR[10] [10]; //column 0 t/m 7 - FSR data, column 8 - lap number, column 9 - posture lable
int listPE[10] [8]; //column 0 t/m 5 - PE data, column 6 - lap number, column 7 - posture lable

void setupLED(){
    DigitalOut ledPin(LED1);
}

void introTekst(){
    int c;
    pc.printf("\nTo start test press ENTER... \n \n");
    pc.printf("When you have pressed enter, a 5 second countdown will begin. After this countdown, the test will begin. \n \n");
    pc.printf("You have to follow the pattern listed below 10 times: \n");
    pc.printf("1. Right side \n");
    pc.printf("2. Back \n");
    pc.printf("3. Left side \n");
    pc.printf("4. Out of bed \n \n");
    pc.printf("A long PIEEP indicates you to switch to the next position on the list, you have 5 seconds to switch. \n");
    pc.printf("Two short PIEP's indicates you that the measurement has begun. Do not move during this period of 15 seconds. \n");
    pc.printf("Three long PIEEEEP's will indicate you that the test has finished. \n \n");
    pc.printf("Good luck!\n");
    fflush(stdout);
    do c = getchar(); while((c != '\n') && (c != EOF)); //Press enter to continue
    pc.printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n"); 
}
  
void piepLong(){ //create long piep sound one time
    ledPin = 1;
    pc.printf("PIEEEEEEEP");
    wait_ms(1000);
    ledPin = 0;
    pc.printf("\n");
}

void piepShort(int x){ //create short piep sound for x times
    for(int i=1; i<=x; i++){ 
        ledPin = 1;
        pc.printf("PIEP ");
        wait_ms(200);
        ledPin = 0;
    }
    pc.printf("\n");
}   

void countDown(){ //countdown from 5. makes short piep sound every second
    for(int i=5; i>=1; i--){
        ledPin = 1;
        pc.printf("%d", i);
        pc.printf("\n");
        wait_ms(500);
        ledPin = 0;
        wait_ms(500);
    }
}    
    
int main() {
    pc.baud(baud_rate);
    introTekst(); //explaination screen about the test  
    countDown(); //5 seconds countdown
        
    for(int i=1; i<=10; i++){ //10 times loop
        pc.printf("Lap "); //print lap number
        pc.printf("%d", i); //print lap number
        pc.printf("\n"); //print lap number
    
        piepLong(); //right side signal
        wait_ms(5000); //time for turning
        piepShort(2); //create short piep sound two times
        pc.printf("collect data right side\n"); //extra information for testing
        //code collect data
        wait_ms(5000); //time for collecting data  
        // end of placeholder collect data code
         
        piepLong(); //back side signal
        wait_ms(5000); //time for turning
        piepShort(2); //creat short piep sound two times
        pc.printf("collect data back side\n"); //extra information for testing
        //code collect data
        wait_ms(5000); //time for collecting data   
        // end of placeholder collect data code
        
        piepLong(); //left side signal
        wait_ms(5000); //time for turning
        piepShort(2); //creat short piep sound two times
        pc.printf("collect data left side\n"); //extra information for testing
        //code collect data
        wait_ms(5000); //time for collecting data   
        // end of placeholder collect data code
        
        piepLong(); //out of bed signal
        wait_ms(5000); //time for turning
        piepShort(2); //creat short piep sound two times
        pc.printf("collect data out of bed\n"); //extra information for testing
        //code collect data
        wait_ms(5000); //time for collecting data  
        // end of placeholder collect data code
    }   
    
    piepLong(); //final piep sounds, signal that test has finished
    piepLong(); //final piep sounds
    piepLong(); //final piep sounds
           
    return 0;
}
