#include "mbed.h"
#include "compute.h"

int d_x_start, d_y_start;
Serial pc(USBTX, USBRX);

void DEMO_init(double& ba, double& bb) {
   Point2Angles(d_x_start,d_y_start,ba,bb);
}

int demo_step = 0;
void demo_newPos(double rad_a, double rad_b, double& nexta, double& nextb, bool& pushing) {
    int next_x, next_y;
    
    if (demo_step < 10) {
        next_x = 0;
        next_y = d_y_start;
    } else if (demo_step < 20) {
        next_x = 0;
        next_y = compute_max('Y', next_x);
        pushing = true;
    } else if (demo_step < 25) {
        next_x = -25;
        next_y = d_y_start;
    } else if (demo_step < 35) {
        next_x = 25;
        next_y = d_y_start;
    } else if (demo_step < 40) {
        next_x = 20;
        next_y = compute_max('Y', next_x);
        pushing = true;
    } else {
        next_x = 0;
        next_y = d_y_start;   
    }
    
    demo_step++;
    demo_step %= 80;
    
    double next_a, next_b;
    Point2Angles(next_x, next_y, next_a, next_b);
    pc.printf("Newpos: %i, %i, %f, %f\r\n", next_x, next_y, next_a, next_b);
    nexta = next_a;
    nextb = next_b;
}