#include "mbed.h"
#include "compute.h" 
#include "inbetweencontroller.h"
#include <algorithm>

double      x_start = 0;
double      y_start = 18;
double      prev_dir;
bool        was_pushing = false;
bool        goingBack = false;

void IBC_init(double& ba, double& bb) {
   Point2Angles(x_start,y_start,ba,bb);
}

void newPos(double emg1, double emg2, double emg3, double rad_a, double rad_b, double& nexta, double& nextb, bool& pushing) {
    double next_a, next_b;
    double dir = emg1-emg2;
    double cur_x, cur_y;
    
    Angles2Point(rad_a, rad_b, cur_x, cur_y);
    
    double next_x, next_y;
    if(emg3 > 0.5 && !goingBack) {
        next_x = cur_x;
        next_y = compute_max('Y', cur_x);
        was_pushing = true;
        pushing = true;
    } 
    else {
        if(was_pushing) {
            goingBack = true;
            Point2Angles(x_start, y_start, nexta, nextb);
            pushing = false;
            
            // If the current x and y are close nough to the starting position, stop going back and return control to the player
            if(fabs(cur_x-x_start) < 5 && fabs(cur_y-y_start) < 5) {
                was_pushing = false;
                goingBack = false;
            }
            return;
        }

        next_y = y_start;
        if(dir == 0) next_x = cur_x;
        
        // If the robot is moving, move it to one of the waypoints
        else if(dir > 0) {
            if (cur_x >= 15) {
                next_x = compute_max('X', next_y) - 8;
            } else if (cur_x >= 6) {
                next_x = 18;
            } else if (cur_x >= -3) {
                next_x = 9;
            } else if (cur_x >= -12) {
                next_x = 0;
            } else if (cur_x >= -21) {
                next_x = -9;
            } else {
                next_x = -18;
            }
        } 
        else {
            if (cur_x <= -15)
                next_x = -compute_max('X', next_y) + 8;
            else if (cur_x <= -6) {
                next_x = -18;
            } else if (cur_x <= 3) {
                next_x = -9;
            } else if (cur_x <= 12) {
                next_x = 0;
            } else if (cur_x <= 21) {
                next_x = 9;
            } else {
                next_x = 18;
            }
        }
        was_pushing = false;
        pushing = false;
    }
    
    prev_dir = dir;
    
    // Calculate the angle the motors need to be in in order to get to the desired point.
    Point2Angles(next_x, next_y, next_a, next_b);
    nexta = next_a;
    nextb = next_b;
}