#include "mbed.h"
#include "HIDScope.h"

#define MOV_AVG_NUM     100

//Define objects
AnalogIn    b_emg(A0); //Analog input bicep
AnalogIn    t_emg(A1); //Analog input tricep
AnalogIn    p_emg(A2); //Analog input bicep for push
Ticker      sample_timer;
HIDScope    scope(6);

double b_highV[4];
double b_lowV[4];
double t_highV[4];
double t_lowV[4];
double p_highV[4];
double p_lowV[4];

//double lastOutputs[MOV_AVG_NUM-1];

double filter(double input, double coeff_input[], double coeff_output[], double prev_outputs[])
{
    double new_input = input;
    for(int i=1; i<5; i++) 
        new_input -= coeff_input[i] * prev_outputs[i-1];

    double new_output = coeff_output[0] * new_input;
    for(int i=1; i<5; i++) 
        new_output += coeff_output[i] * prev_outputs[i-1];

    // Set the new output as the first value of the 'recent outputs'
    for(int i = 3; i > 0; i--)
        prev_outputs[i] = prev_outputs[i-1];
    prev_outputs[0] = new_input;
    return new_output;
}
double fh_b[]= {0.7602, -3.0406, 4.5609, -3.0406, 0.7602};
double fh_a[]= {1, -3.4532, 4.5041, -2.6273, 0.5778};
double b_highpass_filter(double u)
{
    return filter(u, fh_a, fh_b, t_highV);
    }
double t_highpass_filter(double u)
{
    return filter(u, fh_a, fh_b, b_highV);
}
double p_highpass_filter(double u)
{
    return filter(u, fh_a, fh_b, p_highV);
}

double fl_b[]= {0.00001329,    0.00005317,    0.00007976,   0.00005317,    0.00001329};
double fl_a[]= {1.0000,   -3.6717,    5.0680,   -3.1160,    0.7199};
double b_lowpass_filter(double u)
{
        return filter(u, fl_a, fl_b, t_lowV);
}
double t_lowpass_filter(double u)
{

    return filter(u, fl_a, fl_b, b_lowV);
}
double p_lowpass_filter(double u)
{

    return filter(u, fl_a, fl_b, p_lowV);
}

double last_biceps = 0;
double last_triceps = 0;
double last_push = 0;
/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    double b_input = b_emg.read();
    double output1 = b_highpass_filter(b_input);
    double output2 = fabs(output1);
    double output3 = b_lowpass_filter(output2);
      
    double t_input = t_emg.read();
    double output4 = t_highpass_filter(t_input);
    double output5 = fabs(output4);
    double output6 = t_lowpass_filter(output5);
    
    double p_input = p_emg.read();
    double output7 = p_highpass_filter(p_input);
    double output8 = fabs(output7);
    double output9 = p_lowpass_filter(output8);
    
    /*double tot = output3;
    for(int i=0; i<MOV_AVG_NUM-1; i++) {
        tot += lastOutputs[i];
        if(i != 0) lastOutputs[i] = lastOutputs[i-1];
    }
    lastOutputs[0] = output3;
    output3 = tot/MOV_AVG_NUM;*/
    
    /* Second, set the sampled emg value in channel zero (the first channel) in the 'HIDScope' variable named 'scope' */
       
    double bicout;
    double tricout;
    double pushout;
    if (last_biceps == 0 and output3 > 0.06) {
        bicout = 1;
    } else if (last_biceps == 1 and output3 < 0.045) {
        bicout = 0;
    } else {
        bicout = last_biceps;   
    }
    last_biceps = bicout;
    
    /*if (output3>0.06) {//This is the output for the right bicep
        bicout=1;
    } else if(output3>0.04) {
        bicout=0.5;
    } else {
        bicout=0;
    }*/
    
    /*if (output6>0.0561) {//this is the output for the right tricep
        tricout=1;
    } else if(output6>0.0380) {
        tricout=0.5;
    } else {
        tricout=0;
    }*/
    
    if (last_triceps == 0 and output6 > 0.045) {
        tricout = 1;
    } else if(last_triceps == 1 and output6 < 0.04) {
        tricout = 0;    
    } else {
        tricout = last_triceps;
    }
    last_triceps = tricout;
    
    if (output9>0.05) {//this is the output for the left bicep (the push motion)
        pushout=1;
    } else {
        pushout=0;
    }
    
    scope.set(0,output3);
    scope.set(1,output6);
    scope.set(2,output9);
    scope.set(3,bicout);
    scope.set(4,tricout);
    scope.set(5,pushout);
    /* Repeat the step above if required for more channels (channel 0 up to 5 = 6 channels) */
    /* Finally, send all channels to the PC at once */
    scope.send();
}

int main()
{
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds
    */
    sample_timer.attach(&sample, 0.002);

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}