#ifndef __BLE_TEMPERATURE_MEASURE_SERVICE_H__
#define __BLE_TEMPERATURE_MEASURE_SERVICE_H__

class TemperatureMeasureService {
public:
    const static uint16_t TEMPERATURE_MEASURE_SERVICE_UUID = 0xA002;
    const static uint16_t TEMPERATURE_CHARACTERISTIC_UUID = 0xA003;

    TemperatureMeasureService(BLEDevice &_ble, float temperature) :
        ble(_ble), 
        temperatureValue(TEMPERATURE_CHARACTERISTIC_UUID, &temperature, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&temperatureValue};
        GattService         getTemperatureService(TEMPERATURE_MEASURE_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(getTemperatureService);
    }

    GattAttribute::Handle_t getValueHandle() const {
        return temperatureValue.getValueHandle();
    }
    
    void updateTemperature(uint8_t newTemp) {
        ble.gattServer().write(temperatureValue.getValueHandle(), &newTemp, 1);
    }

public:
    BLEDevice                         &ble;
    ReadWriteGattCharacteristic<float>  temperatureValue;
};

#endif /* #ifndef __BLE_TEMPERATURE_MEASURE_SERVICE_H__ */