#ifndef __BLE_PRESENCE_DETECTION_SERVICE_H__
#define __BLE_PRESENCE_DETECTION_SERVICE_H__

class PresenceDetectionService {
public:
    const static uint16_t PRESENCE_DETECTION_SERVICE_UUID = 0xA000;
    const static uint16_t PRESENCE_CHARACTERISTIC_UUID = 0xA001;

    PresenceDetectionService(BLEDevice &_ble, uint8_t presence) :
        ble(_ble), 
        presenceValue(PRESENCE_CHARACTERISTIC_UUID, &presence, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&presenceValue};
        GattService         getPresenceService(PRESENCE_DETECTION_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(getPresenceService);
    }

    GattAttribute::Handle_t getValueHandle() const {
        return presenceValue.getValueHandle();
    }
    
    void updatePresence(uint8_t newPresence) {
        ble.gattServer().write(presenceValue.getValueHandle(), &newPresence, 1);
    }

public:
    BLEDevice                         &ble;
    ReadWriteGattCharacteristic<uint8_t>  presenceValue;
};

#endif /* #ifndef __BLE_PRESENCE_DETECTION_SERVICE_H__ */